/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.List;

public abstract class Javadoc {
    private final boolean editable;
    protected boolean condensed;
    protected List<String> content;
    protected String author;
    protected String version;
    protected String since;
    protected List<Pair<String, String>> params;
    protected String returnVal;

    protected Javadoc(boolean editable, boolean condensed, List<String> content, String author, String version, String since, List<Pair<String, String>> params, String returnVal) {
        this.editable = editable;
        this.condensed = condensed;
        this.content = content;
        this.author = author;
        this.version = version;
        this.since = since;
        this.params = params;
        this.returnVal = returnVal;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isCondensed() {
        return this.condensed;
    }

    public List<String> getContent() {
        return this.content;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSince() {
        return this.since;
    }

    public List<Pair<String, String>> getParams() {
        return this.params;
    }

    public String getReturnVal() {
        return this.returnVal;
    }

    public String toString() {
        StringBuilder doc = new StringBuilder("/**");
        boolean haveContent = ListUtil.isNotBlank(this.content);
        boolean haveInfoAnnotations = StringUtil.anyNotBlank((String[])new String[]{this.author, this.version, this.since});
        boolean haveCodeAnnotations = ListUtil.isNotBlank(this.params) || StringUtil.isNotBlank((String)this.returnVal);
        boolean prevContent = false;
        if (!this.condensed && (haveContent || haveInfoAnnotations || haveCodeAnnotations)) {
            doc.append("\n *");
        }
        if (haveContent) {
            for (String string : this.content) {
                doc.append(" ").append(string).append("\n *");
            }
            if (!haveInfoAnnotations && !haveCodeAnnotations) {
                doc.delete(doc.length() - 3, doc.length());
            } else {
                doc.append(" ");
            }
            prevContent = true;
        }
        if (StringUtil.isNotBlank((String)this.author)) {
            if (prevContent) {
                doc.append("\n *");
            }
            doc.append(" @author ").append(this.author);
            prevContent = true;
        }
        if (StringUtil.isNotBlank((String)this.version)) {
            if (prevContent) {
                doc.append("\n *");
            }
            doc.append(" @version ").append(this.version);
            prevContent = true;
        }
        if (StringUtil.isNotBlank((String)this.since)) {
            if (prevContent) {
                doc.append("\n *");
            }
            doc.append(" @since ").append(this.since);
            prevContent = true;
        }
        if (haveInfoAnnotations && haveCodeAnnotations) {
            doc.append("\n * ");
        }
        if (ListUtil.isNotBlank(this.params)) {
            if (prevContent) {
                doc.append("\n *");
            }
            for (Pair pair : this.params) {
                doc.append(" @param ").append((String)pair.getLeft()).append(" ").append((String)pair.getRight()).append("\n *");
            }
            doc.delete(doc.length() - 3, doc.length());
            prevContent = true;
        }
        if (StringUtil.isNotBlank((String)this.returnVal)) {
            if (prevContent) {
                doc.append("\n *");
            }
            doc.append(" @return ").append(this.returnVal);
        }
        if (!this.condensed) {
            doc.append("\n");
        }
        doc.append(" */");
        return doc.toString();
    }

    public boolean equals(Object otherJavadoc) {
        if (otherJavadoc instanceof Javadoc) {
            Javadoc doc = (Javadoc)otherJavadoc;
            return StringUtil.equals((String)this.toString(), (String)doc.toString());
        }
        return false;
    }
}

