/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class JavadocBuilder<JavadocType extends Javadoc> {
    protected boolean condensed = false;
    protected List<String> content = new ArrayList<String>();
    protected String author = null;
    protected String version = null;
    protected String since = null;
    protected List<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
    protected String returnVal = null;

    protected JavadocBuilder() {
    }

    public JavadocBuilder<JavadocType> condensed(boolean condensed) {
        this.condensed = condensed;
        return this;
    }

    public JavadocBuilder<JavadocType> condensed() {
        this.condensed = true;
        return this;
    }

    public JavadocBuilder<JavadocType> content(List<String> content) {
        this.content = content;
        return this;
    }

    public JavadocBuilder<JavadocType> content(String content) {
        this.content.add(content);
        return this;
    }

    public JavadocBuilder<JavadocType> author(String author) {
        this.author = author;
        return this;
    }

    public JavadocBuilder<JavadocType> version(String version) {
        this.version = version;
        return this;
    }

    public JavadocBuilder<JavadocType> since(String since) {
        this.since = since;
        return this;
    }

    public JavadocBuilder<JavadocType> params(List<Pair<String, String>> params) {
        this.params = params;
        return this;
    }

    public JavadocBuilder<JavadocType> param(Pair<String, String> param) {
        this.params.add(param);
        return this;
    }

    public JavadocBuilder<JavadocType> param(String name, String description) {
        this.params.add((Pair<String, String>)Pair.of((Object)name, (Object)description));
        return this;
    }

    public JavadocBuilder<JavadocType> returnVal(String returnVal) {
        this.returnVal = returnVal;
        return this;
    }

    public JavadocType build() {
        return this.constructJavadoc();
    }

    protected abstract JavadocType constructJavadoc();
}

