/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.editable;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaClass;
import com.github.tadukoo.java.JavaClassBuilder;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import java.util.ArrayList;
import java.util.List;

public class EditableJavaClass
extends JavaClass {
    private EditableJavaClass(boolean isInnerClass, String packageName, List<String> imports, List<String> staticImports, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, String className, String superClassName, List<JavaClass> innerClasses, List<JavaField> fields, List<JavaMethod> methods) {
        super(true, isInnerClass, packageName, imports, staticImports, javadoc, annotations, visibility, isStatic, className, superClassName, innerClasses, fields, methods);
    }

    public static EditableJavaClassBuilder builder() {
        return new EditableJavaClassBuilder();
    }

    public void setInnerClass(boolean isInnerClass) {
        this.isInnerClass = isInnerClass;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void addImport(String anImport) {
        this.imports.add(anImport);
    }

    public void addImports(List<String> imports) {
        this.imports.addAll(imports);
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public void addStaticImport(String staticImport) {
        this.staticImports.add(staticImport);
    }

    public void addStaticImports(List<String> staticImports) {
        this.staticImports.addAll(staticImports);
    }

    public void setStaticImports(List<String> staticImports) {
        this.staticImports = staticImports;
    }

    public void setJavadoc(Javadoc javadoc) {
        if (!javadoc.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable Javadoc");
        }
        this.javadoc = javadoc;
    }

    public void addAnnotation(JavaAnnotation annotation) {
        if (!annotation.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable Java Annotations");
        }
        this.annotations.add(annotation);
    }

    public void addAnnotations(List<JavaAnnotation> annotations) {
        for (JavaAnnotation annotation : annotations) {
            if (annotation.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Annotations");
        }
        this.annotations.addAll(annotations);
    }

    public void setAnnotations(List<JavaAnnotation> annotations) {
        for (JavaAnnotation annotation : annotations) {
            if (annotation.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Annotations");
        }
        this.annotations = annotations;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public void addInnerClass(JavaClass innerClass) {
        if (!innerClass.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable inner classes");
        }
        this.innerClasses.add(innerClass);
    }

    public void addInnerClasses(List<JavaClass> innerClasses) {
        for (JavaClass innerClass : innerClasses) {
            if (innerClass.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable inner classes");
        }
        this.innerClasses.addAll(innerClasses);
    }

    public void setInnerClasses(List<JavaClass> innerClasses) {
        for (JavaClass innerClass : innerClasses) {
            if (innerClass.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable inner classes");
        }
        this.innerClasses = innerClasses;
    }

    public void addField(JavaField field) {
        if (!field.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable Java Fields");
        }
        this.fields.add(field);
    }

    public void addFields(List<JavaField> fields) {
        for (JavaField field : fields) {
            if (field.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Fields");
        }
        this.fields.addAll(fields);
    }

    public void setFields(List<JavaField> fields) {
        for (JavaField field : fields) {
            if (field.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Fields");
        }
        this.fields = fields;
    }

    public void addMethod(JavaMethod method) {
        if (!method.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable Java Methods");
        }
        this.methods.add(method);
    }

    public void addMethods(List<JavaMethod> methods) {
        for (JavaMethod method : methods) {
            if (method.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Methods");
        }
        this.methods.addAll(methods);
    }

    public void setMethods(List<JavaMethod> methods) {
        for (JavaMethod method : methods) {
            if (method.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Methods");
        }
        this.methods = methods;
    }

    public static class EditableJavaClassBuilder
    extends JavaClassBuilder<EditableJavaClass> {
        private EditableJavaClassBuilder() {
        }

        @Override
        protected List<String> checkForSpecificErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.javadoc != null && !this.javadoc.isEditable()) {
                errors.add("javadoc is not editable in this editable JavaClass");
            }
            for (JavaAnnotation annotation : this.annotations) {
                if (annotation.isEditable()) continue;
                errors.add("some annotations are not editable in this editable JavaClass");
                break;
            }
            for (JavaClass clazz : this.innerClasses) {
                if (clazz.isEditable()) continue;
                errors.add("some inner classes are not editable in this editable JavaClass");
                break;
            }
            for (JavaField field : this.fields) {
                if (field.isEditable()) continue;
                errors.add("some fields are not editable in this editable JavaClass");
                break;
            }
            for (JavaMethod method : this.methods) {
                if (method.isEditable()) continue;
                errors.add("some methods are not editable in this editable JavaClass");
            }
            return errors;
        }

        @Override
        protected EditableJavaClass constructClass() {
            return new EditableJavaClass(this.isInnerClass, this.packageName, this.imports, this.staticImports, this.javadoc, this.annotations, this.visibility, this.isStatic, this.className, this.superClassName, this.innerClasses, this.fields, this.methods);
        }
    }
}

