/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.editable;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaFieldBuilder;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import java.util.ArrayList;
import java.util.List;

public class EditableJavaField
extends JavaField {
    private EditableJavaField(String sectionComment, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, boolean isFinal, String type, String name, String value) {
        super(true, sectionComment, javadoc, annotations, visibility, isStatic, isFinal, type, name, value);
    }

    public static EditableJavaFieldBuilder builder() {
        return new EditableJavaFieldBuilder();
    }

    public void setSectionComment(String sectionComment) {
        this.sectionComment = sectionComment;
    }

    public void setJavadoc(Javadoc javadoc) {
        if (!javadoc.isEditable()) {
            throw new IllegalArgumentException("editable JavaField requires an editable Javadoc");
        }
        this.javadoc = javadoc;
    }

    public void addAnnotation(JavaAnnotation annotation) {
        if (!annotation.isEditable()) {
            throw new IllegalArgumentException("editable JavaField requires editable Java Annotations");
        }
        this.annotations.add(annotation);
    }

    public void addAnnotations(List<JavaAnnotation> annotations) {
        for (JavaAnnotation annotation : annotations) {
            if (annotation.isEditable()) continue;
            throw new IllegalArgumentException("editable JavaField requires editable Java Annotations");
        }
        this.annotations.addAll(annotations);
    }

    public void setAnnotations(List<JavaAnnotation> annotations) {
        for (JavaAnnotation annotation : annotations) {
            if (annotation.isEditable()) continue;
            throw new IllegalArgumentException("editable JavaField requires editable Java Annotations");
        }
        this.annotations = annotations;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static class EditableJavaFieldBuilder
    extends JavaFieldBuilder<EditableJavaField> {
        @Override
        protected List<String> checkForSpecificErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.javadoc != null && !this.javadoc.isEditable()) {
                errors.add("javadoc is not editable in this editable JavaField");
            }
            for (JavaAnnotation annotation : this.annotations) {
                if (annotation.isEditable()) continue;
                errors.add("some annotations are not editable in this editable JavaField");
            }
            return errors;
        }

        @Override
        protected EditableJavaField constructField() {
            return new EditableJavaField(this.sectionComment, this.javadoc, this.annotations, this.visibility, this.isStatic, this.isFinal, this.type, this.name, this.value);
        }
    }
}

