/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.comment;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.util.StringUtil;

public abstract class JavaSingleLineComment
implements JavaCodeType {
    private final boolean editable;
    protected String content;

    protected JavaSingleLineComment(boolean editable, String content) {
        this.editable = editable;
        this.content = content;
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.SINGLE_LINE_COMMENT;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        return "// " + this.content;
    }

    public boolean equals(Object otherComment) {
        if (otherComment instanceof JavaSingleLineComment) {
            JavaSingleLineComment comment = (JavaSingleLineComment)otherComment;
            return StringUtil.equals((String)this.toString(), (String)comment.toString());
        }
        return false;
    }

    @Override
    public String toBuilderCode() {
        return this.getClass().getSimpleName() + ".builder()\n\t\t.content(\"" + this.escapeQuotes(this.content) + "\")\n\t\t.build()";
    }
}

