/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.importstatement;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.util.StringUtil;

public abstract class JavaImportStatement
implements JavaCodeType {
    private final boolean editable;
    protected boolean isStatic;
    protected String importName;

    protected JavaImportStatement(boolean editable, boolean isStatic, String importName) {
        this.editable = editable;
        this.isStatic = isStatic;
        this.importName = importName;
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.IMPORT_STATEMENT;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getImportName() {
        return this.importName;
    }

    public String toString() {
        StringBuilder statement = new StringBuilder("import").append(' ');
        if (this.isStatic) {
            statement.append("static").append(' ');
        }
        statement.append(this.importName).append(";");
        return statement.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof JavaImportStatement) {
            JavaImportStatement importStatement = (JavaImportStatement)o;
            return StringUtil.equals((String)this.toString(), (String)importStatement.toString());
        }
        return false;
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        if (this.isStatic) {
            codeString.append("\n\t\t").append(".isStatic()");
        }
        codeString.append("\n\t\t").append(".importName(\"").append(this.importName).append("\")").append("\n\t\t").append(".build()");
        return codeString.toString();
    }
}

