/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.method;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.method.JavaMethodBuilder;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public class EditableJavaMethod
extends JavaMethod {
    private EditableJavaMethod(Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isAbstract, boolean isStatic, boolean isFinal, String returnType, String name, List<Pair<String, String>> parameters, List<String> throwTypes, List<String> lines) {
        super(true, javadoc, annotations, visibility, isAbstract, isStatic, isFinal, returnType, name, parameters, throwTypes, lines);
    }

    public static EditableJavaMethodBuilder builder() {
        return new EditableJavaMethodBuilder();
    }

    public void setJavadoc(Javadoc javadoc) {
        if (!javadoc.isEditable()) {
            throw new IllegalArgumentException("editable Java Method requires editable Javadoc");
        }
        this.javadoc = javadoc;
    }

    public void addAnnotation(JavaAnnotation annotation) {
        if (!annotation.isEditable()) {
            throw new IllegalArgumentException("editable Java Method requires editable Java Annotations");
        }
        this.annotations.add(annotation);
    }

    public void addAnnotations(List<JavaAnnotation> annotations) {
        for (JavaAnnotation annotation : annotations) {
            if (annotation.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Method requires editable Java Annotations");
        }
        this.annotations.addAll(annotations);
    }

    public void setAnnotations(List<JavaAnnotation> annotations) {
        for (JavaAnnotation annotation : annotations) {
            if (annotation.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Method requires editable Java Annotations");
        }
        this.annotations = annotations;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addParameter(String type, String name) {
        this.parameters.add(Pair.of((Object)type, (Object)name));
    }

    public void addParameter(Pair<String, String> parameter) {
        this.parameters.add(parameter);
    }

    public void addParameters(List<Pair<String, String>> parameters) {
        this.parameters.addAll(parameters);
    }

    public void setParameters(List<Pair<String, String>> parameters) {
        this.parameters = parameters;
    }

    public void addThrowType(String throwType) {
        this.throwTypes.add(throwType);
    }

    public void addThrowTypes(List<String> throwTypes) {
        this.throwTypes.addAll(throwTypes);
    }

    public void setThrowTypes(List<String> throwTypes) {
        this.throwTypes = throwTypes;
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public void addLines(List<String> lines) {
        this.lines.addAll(lines);
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public static class EditableJavaMethodBuilder
    extends JavaMethodBuilder<EditableJavaMethod> {
        private EditableJavaMethodBuilder() {
        }

        @Override
        protected List<String> checkForSpecificErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.javadoc != null && !this.javadoc.isEditable()) {
                errors.add("javadoc is not editable in this editable JavaMethod");
            }
            for (JavaAnnotation annotation : this.annotations) {
                if (annotation.isEditable()) continue;
                errors.add("some annotations are not editable in this editable JavaMethod");
            }
            return errors;
        }

        @Override
        protected EditableJavaMethod constructMethod() {
            return new EditableJavaMethod(this.javadoc, this.annotations, this.visibility, this.isAbstract, this.isStatic, this.isFinal, this.returnType, this.name, this.parameters, this.throwTypes, this.lines);
        }
    }
}

