/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.java.parsing.classtypes.JavaClassParser;
import com.github.tadukoo.java.parsing.codetypes.JavaAnnotationParser;
import com.github.tadukoo.java.parsing.codetypes.JavaFieldParser;
import com.github.tadukoo.java.parsing.codetypes.JavaImportStatementParser;
import com.github.tadukoo.java.parsing.codetypes.JavaMethodParser;
import com.github.tadukoo.java.parsing.codetypes.JavaPackageDeclarationParser;
import com.github.tadukoo.java.parsing.codetypes.JavaTypeWithModifiersParser;
import com.github.tadukoo.java.parsing.comment.JavaMultiLineCommentParser;
import com.github.tadukoo.java.parsing.comment.JavaSingleLineCommentParser;
import com.github.tadukoo.java.parsing.comment.JavadocParser;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction2;
import java.util.ArrayList;
import java.util.List;

public class FullJavaParser
extends AbstractJavaParser {
    private FullJavaParser() {
    }

    public static JavaCodeType parseType(String content) throws JavaParsingException {
        List<String> tokens = FullJavaParser.splitContentIntoTokens(content);
        ArrayList<JavaCodeType> types = new ArrayList<JavaCodeType>();
        int currentToken = 0;
        while (currentToken < tokens.size()) {
            ThrowingFunction2 parseMethod;
            String token = tokens.get(currentToken);
            if (WHITESPACE_MATCHER.reset(token).matches()) {
                ++currentToken;
                continue;
            }
            if (StringUtil.equals((String)token, (String)"package")) {
                parseMethod = JavaPackageDeclarationParser::parsePackageDeclaration;
            } else if (StringUtil.equals((String)token, (String)"import")) {
                parseMethod = JavaImportStatementParser::parseImportStatement;
            } else if (StringUtil.equals((String)token, (String)"class")) {
                parseMethod = JavaClassParser::parseClass;
            } else if (token.startsWith("/**")) {
                parseMethod = JavadocParser::parseJavadoc;
            } else if (token.startsWith("/*")) {
                parseMethod = JavaMultiLineCommentParser::parseMultiLineComment;
            } else if (token.startsWith("//")) {
                parseMethod = JavaSingleLineCommentParser::parseSingleLineComment;
            } else if (token.startsWith("@")) {
                parseMethod = JavaAnnotationParser::parseAnnotation;
            } else if (MODIFIERS.contains(token)) {
                parseMethod = JavaTypeWithModifiersParser::parseTypeWithModifiers;
            } else {
                JavaCodeTypes typeToParse = FullJavaParser.determineFieldOrMethod(tokens, currentToken);
                if (typeToParse == JavaCodeTypes.FIELD) {
                    parseMethod = JavaFieldParser::parseField;
                } else if (typeToParse == JavaCodeTypes.METHOD) {
                    parseMethod = JavaMethodParser::parseMethod;
                } else {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Failed to determine type from token '" + token + "'");
                }
            }
            ParsingPojo pojo = (ParsingPojo)parseMethod.apply(tokens, (Object)currentToken);
            types.add(pojo.parsedType());
            currentToken = pojo.nextTokenIndex();
        }
        return FullJavaParser.combineTypes(types);
    }

    private static JavaCodeType combineTypes(List<JavaCodeType> types) throws JavaParsingException {
        if (types.size() == 1) {
            return types.get(0);
        }
        JavaPackageDeclaration packageDeclaration = null;
        ArrayList<JavaImportStatement> importStatements = new ArrayList<JavaImportStatement>();
        Javadoc javadoc = null;
        ArrayList<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
        EditableJavaField javaField = null;
        EditableJavaMethod javaMethod = null;
        EditableJavaClass javaClass = null;
        for (JavaCodeType type : types) {
            if (type instanceof JavaPackageDeclaration) {
                JavaPackageDeclaration declaration = (JavaPackageDeclaration)type;
                if (packageDeclaration != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered two package declarations!");
                }
                if (javaClass != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered package declaration after class!");
                }
                packageDeclaration = declaration;
                continue;
            }
            if (type instanceof JavaImportStatement) {
                JavaImportStatement importStmt = (JavaImportStatement)type;
                if (javaClass != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered import statement after class!");
                }
                importStatements.add(importStmt);
                continue;
            }
            if (type instanceof Javadoc) {
                Javadoc doc = (Javadoc)type;
                if (javadoc != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered two Javadocs!");
                }
                if (javaField != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered a Javadoc after field!");
                }
                if (javaMethod != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered a Javadoc after method!");
                }
                if (javaClass != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered a Javadoc after class!");
                }
                javadoc = doc;
                continue;
            }
            if (type instanceof JavaAnnotation) {
                JavaAnnotation annotation = (JavaAnnotation)type;
                if (javaClass != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered annotation after class!");
                }
                annotations.add(annotation);
                continue;
            }
            if (type instanceof EditableJavaField) {
                EditableJavaField field = (EditableJavaField)type;
                if (javaField != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered two fields!");
                }
                if (javaClass != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered field outside a class!");
                }
                if (packageDeclaration != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered package declaration before field!");
                }
                if (!importStatements.isEmpty()) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered import statements before field!");
                }
                if (javadoc != null) {
                    field.setJavadoc(javadoc);
                }
                if (!annotations.isEmpty()) {
                    field.setAnnotations(annotations);
                }
                javaField = field;
                continue;
            }
            if (type instanceof EditableJavaMethod) {
                EditableJavaMethod method = (EditableJavaMethod)type;
                if (javaMethod != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered two methods!");
                }
                if (javaClass != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered method outside a class!");
                }
                if (packageDeclaration != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered package declaration before method!");
                }
                if (!importStatements.isEmpty()) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered import statements before method!");
                }
                if (javadoc != null) {
                    method.setJavadoc(javadoc);
                }
                if (!annotations.isEmpty()) {
                    method.setAnnotations(annotations);
                }
                javaMethod = method;
                continue;
            }
            if (type instanceof EditableJavaClass) {
                EditableJavaClass clazz = (EditableJavaClass)type;
                if (javaClass != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered two outer level classes!");
                }
                if (javaField != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered fields outside a class!");
                }
                if (javaMethod != null) {
                    throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Encountered methods outside a class!");
                }
                if (packageDeclaration != null) {
                    clazz.setPackageDeclaration(packageDeclaration);
                }
                if (!importStatements.isEmpty()) {
                    clazz.setImportStatements(importStatements);
                }
                if (javadoc != null) {
                    clazz.setJavadoc(javadoc);
                }
                if (!annotations.isEmpty()) {
                    clazz.setAnnotations(annotations);
                }
                javaClass = clazz;
                continue;
            }
            throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Unknown how to handle putting '" + type.getJavaCodeType() + "' together with other types!");
        }
        if (javaField != null) {
            return javaField;
        }
        if (javaMethod != null) {
            return javaMethod;
        }
        if (javaClass != null) {
            return javaClass;
        }
        throw new JavaParsingException(JavaCodeTypes.UNKNOWN, "Unable to collect unknown types together");
    }
}

