/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class JavaMultiLineCommentParser
extends AbstractJavaParser {
    private JavaMultiLineCommentParser() {
    }

    public static JavaMultiLineComment parseMultiLineComment(String content) throws JavaParsingException {
        List<String> tokens = JavaMultiLineCommentParser.splitContentIntoTokens(content);
        int startToken = JavaMultiLineCommentParser.skipLeadingWhitespace(tokens);
        ParsingPojo result = JavaMultiLineCommentParser.parseMultiLineComment(tokens, startToken);
        JavaMultiLineCommentParser.verifyEndOfTokens(tokens, result, JavaCodeTypes.MULTI_LINE_COMMENT);
        return (JavaMultiLineComment)result.parsedType();
    }

    public static ParsingPojo parseMultiLineComment(List<String> tokens, int startToken) throws JavaParsingException {
        String firstToken = tokens.get(startToken);
        if (!firstToken.startsWith("/*")) {
            throw new JavaParsingException(JavaCodeTypes.MULTI_LINE_COMMENT, "First token of multi-line comment must start with '/*'");
        }
        StringBuilder line = new StringBuilder();
        if (StringUtil.notEquals((String)firstToken, (String)"/*")) {
            line.append(firstToken.substring("/*".length()));
        }
        boolean justHadNewline = false;
        int currentToken = startToken + 1;
        if (currentToken < tokens.size() && StringUtil.equals((String)tokens.get(currentToken), (String)"\n")) {
            ++currentToken;
            justHadNewline = true;
        }
        ArrayList<String> content = new ArrayList<String>();
        boolean foundClosing = false;
        while (currentToken < tokens.size() && !foundClosing) {
            block17: {
                String toAddToLine;
                block16: {
                    String token;
                    block15: {
                        token = tokens.get(currentToken);
                        toAddToLine = "";
                        if (!StringUtil.equals((String)token, (String)"\n")) break block15;
                        justHadNewline = true;
                        content.add(StringUtil.trim((String)line.toString()));
                        line = new StringBuilder();
                        break block16;
                    }
                    if (justHadNewline && WHITESPACE_MATCHER.reset(token).matches()) break block17;
                    if (StringUtil.equals((String)token, (String)"*") && justHadNewline) {
                        justHadNewline = false;
                    } else if (token.endsWith("*/")) {
                        foundClosing = true;
                        if (StringUtil.notEquals((String)token, (String)"*/")) {
                            toAddToLine = token.substring(0, token.length() - "*/".length());
                        }
                    } else {
                        toAddToLine = token;
                        justHadNewline = false;
                    }
                }
                if (StringUtil.isNotBlank((String)toAddToLine)) {
                    line.append(toAddToLine);
                }
            }
            ++currentToken;
        }
        if (!line.isEmpty() && !WHITESPACE_MATCHER.reset(line.toString()).matches()) {
            content.add(StringUtil.trim((String)line.toString()));
        }
        if (!foundClosing) {
            throw new JavaParsingException(JavaCodeTypes.MULTI_LINE_COMMENT, "Failed to find closing multi-line comment token!");
        }
        return new ParsingPojo(currentToken, (JavaCodeType)EditableJavaMultiLineComment.builder().content(content).build());
    }
}

