/*
 * Decompiled with CFR 0.152.
 */
package com.github.taymindis.jh;

import com.github.taymindis.jh.Dispatcher;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class DispatcherFuture
extends Dispatcher {
    private HttpServletResponse response;
    private Future<Void> f;
    private Object result;

    protected DispatcherFuture(HttpServletRequest request, HttpServletResponse response) {
        super(request);
        this.response = response;
        this.f = null;
        this.result = null;
    }

    @Override
    public DispatcherFuture addAttribute(String key, Object val) {
        super.setAttribute(key, val);
        return this;
    }

    @Override
    public DispatcherFuture a(String key, Object val) {
        super.setAttribute(key, val);
        return this;
    }

    @Override
    public synchronized DispatcherFuture dispatch(final String jspPathAndParam) throws Exception {
        if (DispatcherFuture.isDispatchFutureEnabled()) {
            throw new Exception("Background Task feature is not enabled");
        }
        if (this.f != null) {
            throw new Exception("Process has been executed");
        }
        final DispatcherFuture df = this;
        this.f = DispatcherFuture.getBgExecutor().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DispatcherFuture.this.getRequest().getRequestDispatcher(Dispatcher.resourcePath + jspPathAndParam + Dispatcher.suffix).include((ServletRequest)df, (ServletResponse)new HttpServletResponseWrapper(DispatcherFuture.this.response){

                    public void sendError(int sc) throws IOException {
                        DispatcherFuture.this.httpStatus = sc;
                        super.sendError(sc);
                    }

                    public void sendError(int sc, String msg) throws IOException {
                        DispatcherFuture.this.httpStatus = sc;
                        super.sendError(sc, msg);
                    }

                    public void setStatus(int sc) {
                        DispatcherFuture.this.httpStatus = sc;
                        super.setStatus(sc);
                    }
                });
                return null;
            }
        });
        return this;
    }

    @Override
    public boolean isDone() {
        return this.f.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.f.isCancelled();
    }

    public void setResult(Object rs) {
        this.result = rs;
    }

    public Object getResult() {
        if (this.result == null) {
            try {
                this.f.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.result;
    }

    public Object getResult(long timeout, TimeUnit unit) {
        if (this.result == null) {
            try {
                this.f.get(timeout, unit);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return this.result;
    }
}

