/*
 * Decompiled with CFR 0.152.
 */
package testoptimal.api.FSM;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import testoptimal.api.FSM.Trans;
import testoptimal.api.Util;

public class State {
    private String uid = Util.genUID();
    @SerializedName(value="stateID")
    private String name;
    @SerializedName(value="isFinal")
    private boolean finalState = false;
    @SerializedName(value="isInitial")
    private boolean initialState = false;
    private Map<String, Integer> position;
    @SerializedName(value="transitions")
    private List<Trans> transList = new ArrayList<Trans>();

    public void setPosition(int left_p, int top_p, int width_p, int height_p) {
        this.position = new HashMap<String, Integer>();
        this.position.put("left", left_p);
        this.position.put("top", top_p);
        this.position.put("width", width_p);
        this.position.put("height", height_p);
    }

    public State(String name_p) {
        this.name = name_p;
    }

    public String getUid() {
        return this.uid;
    }

    public String getName() {
        return this.name;
    }

    public State addTrans(String name_p, State targetState_p) {
        Trans trans = new Trans(name_p, targetState_p);
        this.transList.add(trans);
        return this;
    }

    public State setFinalState(boolean finalState_p) {
        this.finalState = finalState_p;
        return this;
    }

    public State setInitialState(boolean initialState_p) {
        this.initialState = initialState_p;
        return this;
    }

    public Trans findTrans(String name_p) {
        Optional<Trans> st = this.transList.stream().filter(t -> t.getName().equals(name_p)).findFirst();
        return st.orElseGet(null);
    }
}

