/*
 * Decompiled with CFR 0.152.
 */
package testoptimal.api;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import testoptimal.api.APIError;
import testoptimal.api.Constants;
import testoptimal.api.FSM.Model;
import testoptimal.api.FSM.ModelRequest;
import testoptimal.api.FSM.RunRequest;
import testoptimal.api.FSM.Trans;
import testoptimal.api.RunResult;
import testoptimal.api.Server;

public class ModelAPI {
    private Server svr;
    private Gson gson = new Gson();

    protected ModelAPI(Server svr_p) {
        this.svr = svr_p;
    }

    public void upload(Model model_p) throws APIError {
        String modelJson = this.gson.toJson((Object)model_p);
        this.svr.sendPost("client", "model/upload", modelJson, 200);
    }

    public Model getModel(String modelName_p) throws APIError {
        String retJson = this.svr.sendGet("model", modelName_p + "/getModel", null, 200);
        try {
            Map retMap = new HashMap();
            retMap = (Map)this.gson.fromJson(retJson, retMap.getClass());
            return (Model)this.gson.fromJson((String)retMap.get("modelJson"), Model.class);
        }
        catch (Exception e) {
            throw new APIError(0, "JSON parser error", e.getLocalizedMessage(), "Server.getModel");
        }
    }

    public RunResult genPaths(String modelName_p) throws APIError {
        return this.genPaths(modelName_p, Constants.MbtMode.Optimal, 0);
    }

    public RunResult genPaths(String modelName_p, Constants.MbtMode mbtMode_p) throws APIError {
        return this.genPaths(modelName_p, mbtMode_p, 0);
    }

    public RunResult genPaths(String modelName_p, Constants.MbtMode mbtMode_p, int timeoutMillis_p) throws APIError {
        ModelRequest req = new ModelRequest();
        if (timeoutMillis_p > 0) {
            req.options.put("timeoutMillis", timeoutMillis_p);
        }
        req.mbtMode = mbtMode_p.name();
        req.modelName = modelName_p;
        String reqJson = this.gson.toJson((Object)req);
        String retJson = this.svr.sendPost("client", "model/gen", reqJson, 200);
        RunResult result = (RunResult)this.gson.fromJson(retJson, RunResult.class);
        return result;
    }

    public RunResult genPathsPartial(String modelName_p, List<Trans> transList_p, boolean optimal_p) throws APIError {
        return this.genPathsPartial(modelName_p, transList_p, optimal_p, 0);
    }

    public RunResult genPathsPartial(String modelName_p, List<Trans> transList_p, boolean optimal_p, int timeoutMillis_p) throws APIError {
        ModelRequest req = new ModelRequest();
        if (timeoutMillis_p > 0) {
            req.options.put("timeoutMillis", timeoutMillis_p);
        }
        req.mbtMode = optimal_p ? "MarkedOptimal" : "MarkedSerial";
        List transUIDs = transList_p.stream().map(t -> t.getUid()).collect(Collectors.toList());
        req.options.put("markList", transUIDs);
        req.modelName = modelName_p;
        String reqJson = this.gson.toJson((Object)req);
        String retJson = this.svr.sendPost("client", "model/gen", reqJson, 200);
        RunResult result = (RunResult)this.gson.fromJson(retJson, RunResult.class);
        return result;
    }

    public Map<String, Object> runModel(String modelName_p) throws APIError {
        RunRequest req = new RunRequest();
        req.modelName = modelName_p;
        Gson gson = new Gson();
        String reqJSON = gson.toJson((Object)req);
        String resultJSON = this.svr.sendPost("runtime", "model/run/sync", reqJSON, 200);
        HashMap<String, Object> result = new HashMap();
        result = (Map)gson.fromJson(resultJSON, result.getClass());
        return result;
    }

    public Map<String, Object> runModel(RunRequest runReq_p) throws APIError {
        Gson gson = new Gson();
        String reqJSON = gson.toJson((Object)runReq_p);
        String resultJSON = this.svr.sendPost("runtime", "model/run/sync", reqJSON, 200);
        HashMap<String, Object> result = new HashMap();
        result = (Map)gson.fromJson(resultJSON, result.getClass());
        return result;
    }

    public Map<String, Object> runModelMCase(String modelName_p, String[] mcaseList_p) throws APIError {
        RunRequest req = new RunRequest();
        req.modelName = modelName_p;
        req.options.put("MCaseList", mcaseList_p);
        req.mbtMode = Constants.MbtMode.MCase;
        Gson gson = new Gson();
        String reqJSON = gson.toJson((Object)req);
        String resultJSON = this.svr.sendPost("runtime", "model/run/sync", reqJSON, 200);
        HashMap<String, Object> result = new HashMap();
        result = (Map)gson.fromJson(resultJSON, result.getClass());
        return result;
    }

    public void closeModel(String modelName_p) throws APIError {
        this.svr.sendGet("model", modelName_p + "/close", null, 200);
        this.svr.getAgentAPI().modelClosed();
    }

    public String getGraphModel(String modelName_p, String outFilePath_p) throws APIError {
        return this.svr.getGraph(modelName_p, Constants.GraphType.model.name(), outFilePath_p);
    }

    public String getGraphCoverage(String modelName_p, String outFilePath_p) throws APIError {
        return this.svr.getGraph(modelName_p, Constants.GraphType.coverage.name(), outFilePath_p);
    }

    public String getGraphSequence(String modelName_p, String outFilePath_p) throws APIError {
        return this.svr.getGraph(modelName_p, Constants.GraphType.sequence.name(), outFilePath_p);
    }

    public String getGraphMSC(String modelName_p, String outFilePath_p) throws APIError {
        return this.svr.getGraph(modelName_p, Constants.GraphType.msc.name(), outFilePath_p);
    }
}

