/*
 * Decompiled with CFR 0.152.
 */
package testoptimal.api;

import com.google.gson.Gson;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import testoptimal.api.APIError;
import testoptimal.api.AgentAPI;
import testoptimal.api.DataSetAPI;
import testoptimal.api.ModelAPI;

public class Server {
    private Protocol protocol;
    private String svrHost;
    private int svrPort;
    private String username;
    private String password;
    private String svrURL;
    private String apiURL;
    private DataSetAPI dataSetAPI = new DataSetAPI(this);
    private ModelAPI modelAPI = new ModelAPI(this);
    private AgentAPI agentAPI = new AgentAPI(this);

    public Server(Protocol protocol_p, String svrHost_p, int svrPort_p, String username_p, String password_p) {
        this.protocol = protocol_p;
        this.svrHost = svrHost_p;
        this.svrPort = svrPort_p;
        this.username = username_p;
        this.password = password_p;
        this.svrURL = (Object)((Object)this.protocol) + "://" + this.svrHost + ":" + this.svrPort + "/";
        this.apiURL = this.svrURL + "api/v1/";
    }

    protected String sendGet(String facilityName_p, String cmd_p, String param_p, int expectedStatusCode_p) throws APIError {
        if (param_p == null) {
            param_p = "";
        }
        String url = this.apiURL + facilityName_p + "/" + cmd_p;
        if (param_p != null && !param_p.contentEquals("")) {
            url = url + "?" + param_p;
        }
        RequestSpecification req = RestAssured.given();
        req.auth().preemptive().basic(this.username, this.password);
        Response resp = (Response)req.get(url, new Object[0]);
        if (expectedStatusCode_p > 0 && resp.getStatusCode() != expectedStatusCode_p) {
            throw this.genApiError(resp.getStatusCode(), resp.asString(), url);
        }
        String respString = resp.asString();
        return respString;
    }

    private APIError genApiError(int status_p, String message_p, String url_p) {
        Object err = null;
        try {
            Gson gson = new Gson();
            err = (APIError)gson.fromJson(message_p, err.getClass());
        }
        catch (Exception e) {
            err = new APIError(status_p, "Error", message_p, url_p);
        }
        return err;
    }

    protected String sendPost(String facilityName_p, String cmd_p, String body_p, int expectedStatusCode_p) throws APIError {
        String url = this.apiURL + facilityName_p + "/" + cmd_p;
        RequestSpecification req = RestAssured.given();
        req.auth().preemptive().basic(this.username, this.password);
        req.body(body_p);
        req.contentType("application/json");
        Response resp = (Response)req.post(url, new Object[0]);
        if (expectedStatusCode_p > 0 && resp.getStatusCode() != expectedStatusCode_p) {
            throw this.genApiError(resp.getStatusCode(), resp.asString(), url);
        }
        String respString = resp.asString();
        return respString;
    }

    protected String sendPut(String facilityName_p, String cmd_p, String body_p, int expectedStatusCode_p) throws APIError {
        String url = this.apiURL + facilityName_p + "/" + cmd_p;
        RequestSpecification req = RestAssured.given();
        req.auth().preemptive().basic(this.username, this.password);
        req.body(body_p);
        req.contentType("application/json");
        Response resp = (Response)req.put(url, new Object[0]);
        if (expectedStatusCode_p > 0 && resp.getStatusCode() != expectedStatusCode_p) {
            throw this.genApiError(resp.getStatusCode(), resp.asString(), url);
        }
        String respString = resp.asString();
        return respString;
    }

    protected String getGraph(String modelName_p, String graphType_p, String outFilePath_p) throws APIError {
        String url = this.apiURL + "graph/" + modelName_p + "/" + graphType_p + "?execID=-1";
        RequestSpecification req = RestAssured.given();
        req.auth().preemptive().basic(this.username, this.password);
        Response resp = (Response)req.get(url, new Object[0]);
        if (resp.getStatusCode() != 200) {
            throw this.genApiError(resp.getStatusCode(), resp.asString(), url);
        }
        try (FileOutputStream outStream = new FileOutputStream(outFilePath_p);){
            byte[] image = resp.asByteArray();
            ((OutputStream)outStream).write(image);
        }
        catch (Exception e) {
            throw new APIError(-1, "api", e.getLocalizedMessage(), url);
        }
        File f = new File(outFilePath_p);
        return f.getAbsolutePath();
    }

    public DataSetAPI getDataSetAPI() {
        return this.dataSetAPI;
    }

    public ModelAPI getModelAPI() {
        return this.modelAPI;
    }

    public AgentAPI getAgentAPI() {
        return this.agentAPI;
    }

    public static enum Protocol {
        http,
        https;

    }
}

