/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.query.matchers;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.github.thomasridd.flatsy.query.matchers.FlatsyMatcher;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class JSONPathOneOf
implements FlatsyMatcher {
    String jsonPath = null;
    List<String> options = null;

    public JSONPathOneOf(String jsonPath, List<String> options) {
        this.jsonPath = jsonPath;
        this.options = options;
    }

    @Override
    public boolean matches(FlatsyObject object) {
        if (object.getType() == FlatsyObjectType.Folder) {
            return false;
        }
        try {
            DocumentContext context = JsonPath.parse((InputStream)object.retrieveStream());
            String value = (String)context.read(this.jsonPath, new Predicate[0]);
            return this.options.contains(value);
        }
        catch (IOException e) {
            System.out.println("Could not assess " + object.uri + " for " + this.jsonPath + " in set");
            return false;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }
}

