/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.operations.operators;

import com.github.thomasridd.flatsy.FlatsyDatabase;
import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class Copy
implements FlatsyOperator {
    FlatsyDatabase db;
    boolean copyFolder = false;

    public Copy(FlatsyDatabase db) {
        this.db = db;
    }

    public Copy(FlatsyDatabase db, boolean copyFolder) {
        this.db = db;
        this.copyFolder = copyFolder;
    }

    @Override
    public void apply(FlatsyObject object) {
        if (object.getType() == FlatsyObjectType.Folder || object.getType() == FlatsyObjectType.Null) {
            return;
        }
        ArrayList<FlatsyObject> objectList = new ArrayList<FlatsyObject>();
        if (this.copyFolder) {
            for (FlatsyObject sibling : object.parent().children()) {
                objectList.add(sibling);
            }
        } else {
            objectList.add(object);
        }
        for (FlatsyObject copyObject : objectList) {
            if (copyObject.getType() == FlatsyObjectType.Folder) continue;
            this.db.delete(copyObject);
            try {
                InputStream stream = copyObject.retrieveStream();
                Throwable throwable = null;
                try {
                    this.db.create(copyObject, stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                System.out.println("could not copy: " + copyObject.uri);
            }
        }
    }
}

