/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.operations.operators;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperator;
import java.io.IOException;

public class Rename
implements FlatsyOperator {
    String oldUri = "";
    String moveTo = "";

    public Rename(String oldUri, String moveTo) {
        this.oldUri = oldUri;
        this.moveTo = moveTo;
    }

    @Override
    public void apply(FlatsyObject object) {
        if (object.getType() == FlatsyObjectType.Folder || object.getType() == FlatsyObjectType.Null) {
            return;
        }
        if (object.uri.equalsIgnoreCase(this.oldUri) || object.uri.startsWith(this.oldUri + "/")) {
            String newUri = this.moveTo + object.uri.substring(this.oldUri.length());
            FlatsyObject newObject = object.db.get(newUri);
            try {
                newObject.create(object.retrieveStream());
                object.db.delete(object);
                this.deleteEmptyParents(object);
            }
            catch (IOException e) {
                System.out.println("Could not move Flatsy object " + object.uri);
                e.printStackTrace();
            }
        }
    }

    private void deleteEmptyParents(FlatsyObject object) {
        FlatsyObject folder = object.parent();
        if (folder.children().size() == 0) {
            folder.db.delete(folder);
            this.deleteEmptyParents(folder);
        }
    }
}

