/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.query;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.query.FlatsyQueryResult;
import com.github.thomasridd.flatsy.query.FlatsyQueryType;
import com.github.thomasridd.flatsy.query.matchers.FlatsyMatcher;
import com.github.thomasridd.flatsy.query.matchers.MatcherCommandLineParser;
import java.util.ArrayList;
import java.util.List;

public class FlatsyQuery {
    List<FlatsyMatcher> conditions = new ArrayList<FlatsyMatcher>();
    List<FlatsyMatcher> halfBlockers = new ArrayList<FlatsyMatcher>();
    List<FlatsyMatcher> blockers = new ArrayList<FlatsyMatcher>();

    public FlatsyQuery() {
    }

    public FlatsyQuery(FlatsyQueryType type, FlatsyMatcher matcher) {
        this.query(type, matcher);
    }

    public FlatsyQuery(String string) {
        this.query(string);
    }

    public FlatsyQuery(FlatsyMatcher matcher) {
        this.query(FlatsyQueryType.Condition, matcher);
    }

    public FlatsyQueryResult checkNode(FlatsyObject object) {
        for (FlatsyMatcher blocker : this.blockers) {
            if (!blocker.matches(object)) continue;
            return FlatsyQueryResult.Blocked;
        }
        for (FlatsyMatcher halfBlocker : this.halfBlockers) {
            if (!halfBlocker.matches(object)) continue;
            for (FlatsyMatcher condition : this.conditions) {
                if (condition.matches(object)) continue;
                return FlatsyQueryResult.Blocked;
            }
            return FlatsyQueryResult.MatchThenBlock;
        }
        for (FlatsyMatcher condition : this.conditions) {
            if (condition.matches(object)) continue;
            return FlatsyQueryResult.NoMatch;
        }
        return FlatsyQueryResult.Match;
    }

    public FlatsyQuery query(FlatsyQueryType type, FlatsyMatcher matcher) {
        if (type == FlatsyQueryType.Blocker) {
            this.blockers.add(matcher);
        } else if (type == FlatsyQueryType.ConditionBlocker) {
            this.halfBlockers.add(matcher);
        } else if (type == FlatsyQueryType.Condition) {
            this.conditions.add(matcher);
        }
        return this;
    }

    public FlatsyQuery query(FlatsyMatcher matcher) {
        return this.query(FlatsyQueryType.Condition, matcher);
    }

    public FlatsyQuery query(String queryString) {
        String cleanedString = queryString.toLowerCase();
        if (cleanedString.startsWith("block:")) {
            cleanedString = cleanedString.substring("block:".length());
            return this.query(FlatsyQueryType.Blocker, MatcherCommandLineParser.matcher(cleanedString));
        }
        if (cleanedString.startsWith("stop:")) {
            cleanedString = cleanedString.substring("stop:".length());
            return this.query(FlatsyQueryType.ConditionBlocker, MatcherCommandLineParser.matcher(cleanedString));
        }
        return this.query(FlatsyQueryType.Condition, MatcherCommandLineParser.matcher(cleanedString));
    }
}

