/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.query.matchers;

import com.github.thomasridd.flatsy.FlatsyDatabase;
import com.github.thomasridd.flatsy.query.FlatsyCursor;
import com.github.thomasridd.flatsy.query.matchers.All;
import com.github.thomasridd.flatsy.query.matchers.ExcelValid;
import com.github.thomasridd.flatsy.query.matchers.ExcelValidXLS;
import com.github.thomasridd.flatsy.query.matchers.ExcelValidXLSX;
import com.github.thomasridd.flatsy.query.matchers.Find;
import com.github.thomasridd.flatsy.query.matchers.FlatsyMatcher;
import com.github.thomasridd.flatsy.query.matchers.IsFile;
import com.github.thomasridd.flatsy.query.matchers.IsFolder;
import com.github.thomasridd.flatsy.query.matchers.JSONPathAtLeastOne;
import com.github.thomasridd.flatsy.query.matchers.JSONPathExists;
import com.github.thomasridd.flatsy.query.matchers.JSONPathOneOf;
import com.github.thomasridd.flatsy.query.matchers.JSONValid;
import com.github.thomasridd.flatsy.query.matchers.Not;
import com.github.thomasridd.flatsy.query.matchers.Or;
import com.github.thomasridd.flatsy.query.matchers.UriContains;
import com.github.thomasridd.flatsy.query.matchers.UriEndsWith;
import com.github.thomasridd.flatsy.query.matchers.UriStartsWith;
import com.github.thomasridd.flatsy.util.FlatsyUtil;
import java.util.List;

public class MatcherCommandLineParser {
    public static FlatsyCursor cursorFromFilterCommands(FlatsyDatabase db, List<String> filters) {
        FlatsyCursor cursor = db.root().cursor();
        for (String filter : filters) {
            cursor = MatcherCommandLineParser.applyFilterToCursor(cursor, filter);
        }
        return cursor;
    }

    protected static FlatsyCursor applyFilterToCursor(FlatsyCursor cursor, String filter) {
        return cursor.query(MatcherCommandLineParser.matcher(filter));
    }

    public static FlatsyMatcher matcher(String filter) {
        String keyword;
        String command = filter;
        if (!filter.toLowerCase().startsWith("filter")) {
            command = "FILTER " + filter;
        }
        List<String> args = FlatsyUtil.commandArguments(command);
        FlatsyMatcher matcher = null;
        boolean invert = false;
        if (args.get(1).equalsIgnoreCase("not")) {
            invert = true;
            args.remove(1);
        }
        if ((keyword = args.get(1)).equalsIgnoreCase("files")) {
            matcher = new IsFile();
        } else if (keyword.equalsIgnoreCase("folders")) {
            matcher = new IsFolder();
        } else if (keyword.equalsIgnoreCase("uri_starts")) {
            matcher = new UriStartsWith(args.get(2));
        } else if (keyword.equalsIgnoreCase("uri_contains")) {
            matcher = new UriContains(args.get(2));
        } else if (keyword.equalsIgnoreCase("uri_ends")) {
            matcher = new UriEndsWith(args.get(2));
        } else if (keyword.equalsIgnoreCase("find")) {
            matcher = new Find(args.get(2));
        } else if (keyword.equalsIgnoreCase("jsonpath") || keyword.equalsIgnoreCase("json")) {
            if (args.get(2).startsWith("$")) {
                String jsonPath = args.get(2);
                if (args.get(3).equalsIgnoreCase("equals")) {
                    matcher = new JSONPathOneOf(jsonPath, args.subList(4, args.size()));
                } else if (args.get(3).equalsIgnoreCase("exists")) {
                    matcher = new Or(new JSONPathExists(jsonPath), new JSONPathAtLeastOne(jsonPath));
                }
            } else if (args.get(2).equalsIgnoreCase("valid")) {
                matcher = new JSONValid();
            }
        } else if (keyword.equalsIgnoreCase("xls")) {
            if (args.size() > 1 && args.get(2).equalsIgnoreCase("valid")) {
                matcher = new ExcelValidXLS();
            }
        } else if (keyword.equalsIgnoreCase("xlsx")) {
            if (args.size() > 1 && args.get(2).equalsIgnoreCase("valid")) {
                matcher = new ExcelValidXLSX();
            }
        } else if (keyword.equalsIgnoreCase("excel") && args.size() > 1 && args.get(2).equalsIgnoreCase("valid")) {
            matcher = new ExcelValid();
        }
        if (invert) {
            return new Not(matcher);
        }
        if (matcher == null) {
            return new All();
        }
        return matcher;
    }

    public static FlatsyCursor query(FlatsyCursor cursor, String filter) {
        String command = filter;
        if (!filter.toLowerCase().startsWith("filter")) {
            command = "FILTER " + filter;
        }
        return MatcherCommandLineParser.applyFilterToCursor(cursor, command);
    }
}

