/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.netcom2.network.client;

import com.github.thorbenkuck.netcom2.annotations.rmi.IgnoreRemoteExceptions;
import com.github.thorbenkuck.netcom2.exceptions.RemoteObjectNotRegisteredException;
import com.github.thorbenkuck.netcom2.exceptions.RemoteRequestException;
import com.github.thorbenkuck.netcom2.exceptions.SendFailedException;
import com.github.thorbenkuck.netcom2.logging.Logging;
import com.github.thorbenkuck.netcom2.network.client.RemoteAccessBlockRegistration;
import com.github.thorbenkuck.netcom2.network.client.RemoteObjectHandler;
import com.github.thorbenkuck.netcom2.network.client.Sender;
import com.github.thorbenkuck.netcom2.network.shared.comm.RemoteAccessCommunicationRequest;
import com.github.thorbenkuck.netcom2.network.shared.comm.RemoteAccessCommunicationResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Semaphore;

public class JavaRemoteInformationInvocationHandler<T>
implements RemoteObjectHandler {
    private final Sender sender;
    private final RemoteAccessBlockRegistration remoteAccessBlockRegistration;
    private final Class<?> clazz;
    private final UUID uuid;
    private final Logging logging = Logging.unified();
    private Runnable fallbackRunnable;
    private T fallbackInstance;

    JavaRemoteInformationInvocationHandler(Sender sender, RemoteAccessBlockRegistration remoteAccessBlockRegistration, Class<T> clazz, UUID uuid) {
        this.sender = sender;
        this.remoteAccessBlockRegistration = remoteAccessBlockRegistration;
        this.clazz = clazz;
        this.uuid = uuid;
        this.logging.instantiated((Object)this);
    }

    private Object testForThrow(Class<?> clazz, Method method, Throwable throwable, Object[] args) throws Throwable {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof RemoteObjectNotRegisteredException) {
            return this.executeFallback(throwable, method, args);
        }
        IgnoreRemoteExceptions annotation = method.getAnnotation(IgnoreRemoteExceptions.class);
        if (annotation == null) {
            annotation = clazz.getAnnotation(IgnoreRemoteExceptions.class);
        }
        if (annotation != null) {
            Class<? extends Exception>[] toThrowAnyways = annotation.exceptTypes();
            if (Arrays.asList(toThrowAnyways).contains(throwable.getClass())) {
                this.throwEncapsulated(throwable);
            }
        } else {
            this.throwEncapsulated(throwable);
        }
        return null;
    }

    private void throwEncapsulated(Throwable throwable) throws Throwable {
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        for (Throwable currentCause = throwable.getCause(); currentCause != null; currentCause = currentCause.getCause()) {
            causes.add(currentCause);
        }
        if (!(throwable instanceof RemoteRequestException)) {
            throwable = new RemoteRequestException("Throwable(" + throwable.getClass().getName() + ") received from Server: " + throwable.getMessage());
        }
        for (Throwable cause : causes) {
            throwable.addSuppressed(cause);
        }
        throw throwable;
    }

    protected Object executeFallback(Throwable received, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        JavaRemoteInformationInvocationHandler javaRemoteInformationInvocationHandler = this;
        synchronized (javaRemoteInformationInvocationHandler) {
            if (this.fallbackInstance != null) {
                return method.invoke(this.fallbackInstance, args);
            }
            if (this.fallbackRunnable != null) {
                this.fallbackRunnable.run();
                return null;
            }
            throw new RemoteObjectNotRegisteredException(received.getMessage());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RemoteAccessCommunicationRequest request = new RemoteAccessCommunicationRequest(method.getName(), this.clazz, this.uuid, args);
        try {
            this.sender.objectToServer((Object)request);
        }
        catch (SendFailedException e) {
            return this.executeFallback(e, method, args);
        }
        Semaphore semaphore = this.remoteAccessBlockRegistration.await(request);
        semaphore.acquire();
        RemoteAccessCommunicationResponse response = this.remoteAccessBlockRegistration.getResponse(this.uuid);
        this.remoteAccessBlockRegistration.clearResult(this.uuid);
        this.remoteAccessBlockRegistration.clearSemaphore(this.uuid);
        semaphore.release();
        if (response.getThrownThrowable() != null) {
            return this.testForThrow(this.clazz, method, response.getThrownThrowable(), args);
        }
        return response.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFallbackRunnable(Runnable fallbackRunnable) {
        JavaRemoteInformationInvocationHandler javaRemoteInformationInvocationHandler = this;
        synchronized (javaRemoteInformationInvocationHandler) {
            this.fallbackRunnable = fallbackRunnable;
            this.fallbackInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends T> void setFallbackInstance(S fallbackInstance) {
        JavaRemoteInformationInvocationHandler javaRemoteInformationInvocationHandler = this;
        synchronized (javaRemoteInformationInvocationHandler) {
            this.fallbackInstance = fallbackInstance;
            this.fallbackRunnable = null;
        }
    }
}

