/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.netcom2.network.client;

import com.github.thorbenkuck.netcom2.annotations.rmi.SingletonRemoteObject;
import com.github.thorbenkuck.netcom2.logging.Logging;
import com.github.thorbenkuck.netcom2.network.client.ClientStart;
import com.github.thorbenkuck.netcom2.network.client.InvocationHandlerProducer;
import com.github.thorbenkuck.netcom2.network.client.JavaInvocationHandlerProducer;
import com.github.thorbenkuck.netcom2.network.client.JavaRemoteInformationInvocationHandler;
import com.github.thorbenkuck.netcom2.network.client.RemoteAccessBlockRegistration;
import com.github.thorbenkuck.netcom2.network.client.RemoteObjectFactory;
import com.github.thorbenkuck.netcom2.network.client.Sender;
import com.github.thorbenkuck.netcom2.network.shared.CommunicationRegistration;
import com.github.thorbenkuck.netcom2.network.shared.comm.OnReceiveSingle;
import com.github.thorbenkuck.netcom2.network.shared.comm.RemoteAccessCommunicationResponse;
import com.github.thorbenkuck.netcom2.utility.NetCom2Utils;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;

public class NativeRemoteObjectFactory
implements RemoteObjectFactory {
    private final Map<Class<?>, JavaRemoteInformationInvocationHandler<?>> singletons = new HashMap();
    private final Map<Class<?>, Runnable> fallbackRunnableMap = new HashMap();
    private final Map<Class<?>, Object> fallbackInstances = new HashMap();
    private final RemoteAccessBlockRegistration remoteAccessBlockRegistration = new RemoteAccessBlockRegistration();
    private final Semaphore invocationHandlerProducerMutex = new Semaphore(1);
    private final Logging logging = Logging.unified();
    private final RemoteResponseHandler remoteResponseHandler = new RemoteResponseHandler();
    private Runnable defaultFallback;
    private InvocationHandlerProducer invocationHandlerProducer;
    private CommunicationRegistration communicationRegistration;

    NativeRemoteObjectFactory(Sender sender) {
        this.invocationHandlerProducer = new JavaInvocationHandlerProducer(sender, this.remoteAccessBlockRegistration);
        this.logging.instantiated((Object)this);
    }

    private <T> JavaRemoteInformationInvocationHandler<T> produceInvocationHandler(Class<T> clazz) {
        Object o;
        JavaRemoteInformationInvocationHandler<T> invocationHandler;
        SingletonRemoteObject singletonRemoteObject = clazz.getAnnotation(SingletonRemoteObject.class);
        if (singletonRemoteObject != null) {
            this.logging.trace((Object)("Detected SingletonRemoteObject request for " + clazz));
            invocationHandler = this.produceSingleton(clazz);
        } else {
            invocationHandler = this.produceNew(clazz);
        }
        if (invocationHandler == null) {
            this.logging.warn((Object)("The provided InvocationHandlerProducer appears to be faulty! Please check the InvocationHandlerProducer" + this.invocationHandlerProducer + "!"));
            throw new IllegalStateException("InvocationHandler is null! This cannot be recovered!");
        }
        invocationHandler.setFallbackRunnable(this.defaultFallback);
        Runnable runnable = this.fallbackRunnableMap.get(clazz);
        if (runnable != null) {
            invocationHandler.setFallbackRunnable(runnable);
        }
        if ((o = this.fallbackInstances.get(clazz)) != null && clazz.isAssignableFrom(o.getClass())) {
            invocationHandler.setFallbackInstance(o);
        }
        return invocationHandler;
    }

    private <T> JavaRemoteInformationInvocationHandler<T> produceSingleton(Class<T> clazz) {
        this.singletons.computeIfAbsent(clazz, this::produceNew);
        return this.singletons.get(clazz);
    }

    private <T> JavaRemoteInformationInvocationHandler<T> produceNew(Class<T> clazz) {
        this.logging.trace((Object)("Producing new InvocationHandler for " + clazz));
        UUID uuid = this.createUUID();
        try {
            this.logging.trace((Object)"Acquiring access over InvocationHandlerProducer ..");
            this.invocationHandlerProducerMutex.acquire();
            this.logging.trace((Object)"Asking the InvocationHandlerProducer to produce a new InvocationHandler ..");
            JavaRemoteInformationInvocationHandler<T> javaRemoteInformationInvocationHandler = this.invocationHandlerProducer.produce(uuid, clazz);
            return javaRemoteInformationInvocationHandler;
        }
        catch (InterruptedException e) {
            this.logging.error((Object)"Could not create Invocation Handler: Semaphore Interrupted while waiting for access over Producer!", (Throwable)e);
            throw new IllegalStateException("Could not acquire access over invocationHandlerProducer!");
        }
        catch (Exception otherException) {
            this.logging.error((Object)"Encountered unexpected Exception while producing InvocationHandler!", (Throwable)otherException);
            throw new IllegalStateException("Cannot Handle unexpected Exceptions while creating InvocationHandler!", otherException);
        }
        finally {
            this.invocationHandlerProducerMutex.release();
        }
    }

    private synchronized UUID createUUID() {
        return UUID.randomUUID();
    }

    private <T> T createRemoteObject(JavaRemoteInformationInvocationHandler<T> invocationHandler, Class<T> clazz) {
        return (T)Proxy.newProxyInstance(NativeRemoteObjectFactory.class.getClassLoader(), new Class[]{clazz}, invocationHandler);
    }

    @Override
    public void setDefaultFallback(Runnable runnable) {
        NetCom2Utils.parameterNotNull((Object)runnable);
        this.defaultFallback = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFallback(Class<?> clazz, Runnable runnable) {
        NetCom2Utils.parameterNotNull((Object[])new Object[]{clazz, runnable});
        Map<Class<?>, Runnable> map = this.fallbackRunnableMap;
        synchronized (map) {
            this.fallbackRunnableMap.put(clazz, runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, S extends T> void setFallbackInstance(Class<T> clazz, S instance) {
        NetCom2Utils.parameterNotNull((Object[])new Object[]{clazz, instance});
        Map<Class<?>, Object> map = this.fallbackInstances;
        synchronized (map) {
            this.fallbackInstances.put(clazz, instance);
        }
    }

    @Override
    public <T> T create(Class<T> type) {
        return this.createRemoteObject(type);
    }

    @Override
    public <T> T create(Class<T> type, Runnable customFallback) {
        NetCom2Utils.parameterNotNull((Object[])new Object[]{type, customFallback});
        JavaRemoteInformationInvocationHandler<T> invocationHandler = this.produceInvocationHandler(type);
        invocationHandler.setFallbackRunnable(customFallback);
        return this.createRemoteObject(invocationHandler, type);
    }

    @Override
    public <T> T create(Class<T> type, T fallbackInstance) {
        NetCom2Utils.parameterNotNull((Object[])new Object[]{type, fallbackInstance});
        JavaRemoteInformationInvocationHandler<T> invocationHandler = this.produceInvocationHandler(type);
        invocationHandler.setFallbackInstance(fallbackInstance);
        return this.createRemoteObject(invocationHandler, type);
    }

    @Override
    public <T> T createWithoutFallback(Class<T> type) {
        NetCom2Utils.parameterNotNull(type);
        JavaRemoteInformationInvocationHandler<T> invocationHandler = this.produceInvocationHandler(type);
        invocationHandler.setFallbackRunnable(null);
        return this.createRemoteObject(invocationHandler, type);
    }

    public void setup(ClientStart clientStart) {
        this.communicationRegistration = clientStart.getCommunicationRegistration();
        try {
            this.communicationRegistration.acquire();
            this.communicationRegistration.register(RemoteAccessCommunicationResponse.class).addFirst((OnReceiveSingle)this.remoteResponseHandler);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.communicationRegistration.release();
        }
    }

    public void close() {
        try {
            this.communicationRegistration.acquire();
            this.communicationRegistration.register(RemoteAccessCommunicationResponse.class).remove((OnReceiveSingle)this.remoteResponseHandler);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.communicationRegistration.release();
        }
    }

    <T> T createRemoteObject(Class<T> clazz, Runnable fallback) {
        NetCom2Utils.parameterNotNull((Object[])new Object[]{clazz, fallback});
        JavaRemoteInformationInvocationHandler<T> invocationHandler = this.produceInvocationHandler(clazz);
        invocationHandler.setFallbackRunnable(fallback);
        return this.createRemoteObject(invocationHandler, clazz);
    }

    <T, S extends T> T createRemoteObject(Class<T> clazz, S instance) {
        NetCom2Utils.parameterNotNull(clazz);
        JavaRemoteInformationInvocationHandler<T> invocationHandler = this.produceInvocationHandler(clazz);
        invocationHandler.setFallbackInstance(instance);
        return this.createRemoteObject(invocationHandler, clazz);
    }

    <T> T createRemoteObject(Class<T> clazz) {
        NetCom2Utils.parameterNotNull(clazz);
        JavaRemoteInformationInvocationHandler<T> invocationHandler = this.produceInvocationHandler(clazz);
        return this.createRemoteObject(invocationHandler, clazz);
    }

    RemoteAccessBlockRegistration getRemoteAccessBlockRegistration() {
        return this.remoteAccessBlockRegistration;
    }

    void setInvocationHandlerProducer(InvocationHandlerProducer producer) throws InterruptedException {
        NetCom2Utils.assertNotNull((Object)producer);
        try {
            this.invocationHandlerProducerMutex.acquire();
            this.invocationHandlerProducer = producer;
        }
        finally {
            this.invocationHandlerProducerMutex.release();
        }
    }

    private final class RemoteResponseHandler
    implements OnReceiveSingle<RemoteAccessCommunicationResponse> {
        private RemoteResponseHandler() {
        }

        public void accept(RemoteAccessCommunicationResponse remoteAccessCommunicationResponse) {
            NetCom2Utils.parameterNotNull((Object)remoteAccessCommunicationResponse);
            NativeRemoteObjectFactory.this.remoteAccessBlockRegistration.release(remoteAccessCommunicationResponse);
        }
    }
}

