/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class Line
implements Iterable<Character> {
    private String content;
    private final int lineNumber;

    public Line(String content, int lineNumber) {
        this.content = content;
        this.lineNumber = lineNumber;
    }

    public void remove(int index) {
        StringBuilder stringBuilder = new StringBuilder(this.content);
        stringBuilder.deleteCharAt(index);
        this.content = stringBuilder.toString();
    }

    public void remove(int from, int to) {
        for (int index = from; index <= to; ++index) {
            this.remove(0);
        }
    }

    public void changeTo(String newLine) {
        this.content = newLine;
    }

    public void trimLeadingWhiteSpaces() {
        while (this.content.startsWith(" ")) {
            this.content = this.content.replace(" ", "");
        }
    }

    public void trimWhiteSpaces() {
        while (this.content.contains(" ")) {
            this.content = this.content.replace(" ", "");
        }
    }

    public boolean matches(String regex) {
        return this.content.matches(regex);
    }

    public boolean contains(String s) {
        return this.content.contains(s);
    }

    public boolean startsWith(String s) {
        return this.content.startsWith(s);
    }

    public boolean isBlank() {
        for (char character : this.content.toCharArray()) {
            if (character == ' ') continue;
            return false;
        }
        return true;
    }

    public String toReadable() {
        return "(" + this.lineNumber + ") " + this.toString();
    }

    public String toString() {
        return this.content;
    }

    public Line subpart(int begin) {
        return this.subpart(begin, this.content.length());
    }

    public Line subpart(int begin, int end) {
        return new Line(this.content.substring(begin, end), this.lineNumber);
    }

    public int indexOf(String s) {
        return this.content.indexOf(s);
    }

    public int lastIndexOf(String s) {
        return this.content.lastIndexOf(s);
    }

    public String[] split(String regex) {
        return this.content.split(regex);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Line duplicate() {
        return new Line(this.content, this.lineNumber);
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public char getAt(int index) {
        return this.content.toCharArray()[index];
    }

    public void replace(String oldString, String newString) {
        this.content = this.content.replace(oldString, newString);
    }

    public int length() {
        return this.content.length();
    }

    public boolean endsWith(String s) {
        return this.content.endsWith(s);
    }

    public void removeLast() {
        this.remove(this.content.length() - 1);
    }

    public int countCharInLine(char toCount) {
        int count = 0;
        for (int i = 0; i < this.content.length(); ++i) {
            if (this.content.charAt(i) != toCount) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Character> iterator() {
        return new CharacterIterator(this.content.toCharArray());
    }

    private class CharacterIterator
    implements Iterator<Character> {
        private final Queue<Character> elements;
        private Character current;

        private CharacterIterator(Collection<Character> elements) {
            this.elements = new LinkedList<Character>(elements);
        }

        private CharacterIterator(char[] elements) {
            ArrayList<Character> ourList = new ArrayList<Character>();
            for (char currentChar : elements) {
                ourList.add(Character.valueOf(currentChar));
            }
            this.elements = new LinkedList<Character>(ourList);
        }

        @Override
        public boolean hasNext() {
            return this.elements.peek() != null;
        }

        @Override
        public Character next() {
            this.current = this.elements.poll();
            return this.current;
        }
    }
}

