/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.Script;
import com.github.thorbenkuck.scripting.exceptions.ExecutionFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;

class ScriptImpl
implements Script {
    private final Queue<Consumer<Register>> core = new LinkedList<Consumer<Register>>();
    private final Map<String, String> initialRegisterValues = new HashMap<String, String>();

    ScriptImpl() {
        this(new LinkedList<Consumer<Register>>());
    }

    ScriptImpl(Queue<Consumer<Register>> core) {
        this.core.addAll(core);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConsumer(Collection<Consumer<Register>> consumer) {
        Queue<Consumer<Register>> queue = this.core;
        synchronized (queue) {
            this.core.clear();
            this.core.addAll(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Map<String, String> registerValues) throws ExecutionFailedException {
        Map<String, String> map = this.initialRegisterValues;
        synchronized (map) {
            this.initialRegisterValues.putAll(registerValues);
        }
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws ExecutionFailedException {
        LinkedList<Consumer<Register>> consumerCopy;
        Register register = new Register();
        Map<String, String> map = this.initialRegisterValues;
        synchronized (map) {
            register.adapt(this.initialRegisterValues);
        }
        Queue<Consumer<Register>> queue = this.core;
        synchronized (queue) {
            consumerCopy = new LinkedList<Consumer<Register>>(this.core);
        }
        try {
            while (consumerCopy.peek() != null) {
                Consumer consumer = (Consumer)consumerCopy.poll();
                consumer.accept(register);
            }
        }
        catch (Exception e) {
            throw new ExecutionFailedException(e);
        }
        finally {
            register.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList<Consumer<Register>> consumerCopy;
        int lineCounter = 0;
        StringBuilder result = new StringBuilder("------ SCRIPT_START" + System.lineSeparator());
        Queue<Consumer<Register>> queue = this.core;
        synchronized (queue) {
            consumerCopy = new ArrayList<Consumer<Register>>(this.core);
        }
        for (Consumer consumer : consumerCopy) {
            result.append("(").append(lineCounter++).append("): ").append(consumer).append(System.lineSeparator());
        }
        result.append("------ SCRIPT_END");
        return result.toString();
    }

    @Override
    public void setValue(String key, String value) {
        this.initialRegisterValues.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countInstructions() {
        Queue<Consumer<Register>> queue = this.core;
        synchronized (queue) {
            return this.core.size();
        }
    }
}

