/*
 * Decompiled with CFR 0.152.
 */
package com.trows.taskExecutor.Task;

import com.trows.taskExecutor.Exception.IllegalRunnableException;
import com.trows.taskExecutor.Task.Task;
import com.trows.taskExecutor.ThreadPool.BlockingTaskExecutor;
import com.trows.taskExecutor.runnable.AbstractRunnable;
import com.trows.taskExecutor.runnable.BaseRunnable;
import com.trows.taskExecutor.runnable.SyncEndRunnable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ListTask
implements Task {
    private static final Logger logger = Logger.getLogger(ListTask.class);
    private ExecutorService executorService;
    private List taskList = null;
    private Map<String, Object> params = null;
    private Class<?> clazz;
    private boolean isLegal;
    private static int corePoolSize = Runtime.getRuntime().availableProcessors() * 2;

    public ListTask(Class runnableClass) {
        this(null, runnableClass, null);
    }

    public ListTask(List taskList, Class runnableClass) {
        this(taskList, runnableClass, null);
    }

    public ListTask(List taskList, Class runnableClass, Map<String, Object> params) {
        this.taskList = taskList;
        this.executorService = BlockingTaskExecutor.getExecutorService();
        this.params = params;
        try {
            this.clazz = Class.forName(runnableClass.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        try {
            if (this.clazz.newInstance() instanceof AbstractRunnable) {
                this.isLegal = true;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private BaseRunnable getRunnable(List partList) throws IllegalAccessException, InstantiationException {
        Field field;
        BaseRunnable runnable = (BaseRunnable)this.clazz.newInstance();
        if (partList != null) {
            try {
                field = this.clazz.getDeclaredField("taskList");
                field.setAccessible(true);
                field.set(runnable, partList);
            }
            catch (NoSuchFieldException e) {
                logger.error((Object)"No such taskList", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
        }
        if (this.params != null) {
            try {
                field = this.clazz.getDeclaredField("params");
                field.setAccessible(true);
                field.set(runnable, this.params);
            }
            catch (NoSuchFieldException e) {
                logger.error((Object)"No such params map", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
        }
        return runnable;
    }

    @Override
    public boolean doTask() throws IllegalRunnableException {
        return this.doTask(corePoolSize);
    }

    @Override
    public boolean doTask(int availabilityThread) throws IllegalRunnableException {
        BaseRunnable baseJob;
        if (!this.isLegal) {
            throw new IllegalRunnableException();
        }
        int max = (int)Math.ceil((double)this.taskList.size() / ((double)availabilityThread * 1.0));
        if (max == 0) {
            max = 1;
        }
        int tag = (int)Math.ceil((double)this.taskList.size() / ((double)max * 1.0));
        ArrayList<Future> list = new ArrayList<Future>(tag);
        try {
            baseJob = this.getRunnable(this.taskList);
            baseJob.before();
            this.distribute(max, tag, list);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            return false;
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            return false;
        }
        return this.block(list, baseJob);
    }

    private boolean block(List<Future> list, BaseRunnable baseJob) {
        try {
            for (Future future : list) {
                future.get();
            }
            baseJob.after();
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
            return false;
        }
        catch (ExecutionException e) {
            logger.error((Object)e);
            return false;
        }
        return true;
    }

    @Override
    public void doTaskAsyn() throws IllegalRunnableException {
        this.doTaskAsyn(corePoolSize);
    }

    @Override
    public void doTaskAsyn(int availabilityThread) throws IllegalRunnableException {
        if (!this.isLegal) {
            throw new IllegalRunnableException();
        }
        int max = (int)Math.ceil((double)this.taskList.size() / ((double)availabilityThread * 1.0));
        if (max == 0) {
            max = 1;
        }
        int tag = (int)Math.ceil((double)this.taskList.size() / ((double)max * 1.0));
        ArrayList<Future> list = new ArrayList<Future>(tag);
        try {
            BaseRunnable baseJob = this.getRunnable(this.taskList);
            baseJob.before();
            this.distribute(max, tag, list);
            this.executorService.execute(new SyncEndRunnable(baseJob, list));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    private void distribute(int max, int tag, List<Future> list) throws IllegalAccessException, InstantiationException {
        for (int i = 0; i < tag; ++i) {
            List partList = i == tag - 1 ? this.taskList.subList(i * max, this.taskList.size()) : this.taskList.subList(i * max, (i + 1) * max);
            list.add(this.executorService.submit(this.getRunnable(partList)));
        }
    }
}

