/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole;

import beifengtz.vmconsole.entity.jstack.JStackResult;
import beifengtz.vmconsole.exception.AttachingException;
import beifengtz.vmconsole.tools.jstack.JStackTool;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.InputStream;
import sun.tools.attach.HotSpotVirtualMachine;

public class JStackCmd {
    public static JStackResult threadStack(int vmId) throws IllegalArgumentException, Exception {
        return JStackCmd.run(new String[]{"-F", String.valueOf(vmId)});
    }

    public static JStackResult jniStack(int vmId) throws IllegalArgumentException, Exception {
        return JStackCmd.run(new String[]{"-m", String.valueOf(vmId)});
    }

    public static JStackResult threadDump(int vmId) throws IllegalArgumentException, Exception {
        return JStackCmd.run(new String[]{"-l", String.valueOf(vmId)});
    }

    public static JStackResult run(String[] var0) throws IllegalArgumentException, Exception {
        int var8;
        String var5;
        int var4;
        if (var0.length == 0) {
            JStackCmd.usage();
            throw new IllegalArgumentException("Parameter can not be empty.");
        }
        boolean var1 = false;
        boolean var2 = false;
        boolean var3 = false;
        for (var4 = 0; var4 < var0.length && (var5 = var0[var4]).startsWith("-"); ++var4) {
            if (!var5.equals("-help") && !var5.equals("-h")) {
                if (var5.equals("-F")) {
                    var1 = true;
                    continue;
                }
                if (var5.equals("-m")) {
                    var2 = true;
                    continue;
                }
                if (var5.equals("-l")) {
                    var3 = true;
                    continue;
                }
                JStackCmd.usage();
                throw new IllegalArgumentException("The parameter is invalid.");
            }
            JStackCmd.usage();
        }
        if (var2) {
            var1 = true;
        }
        if ((var8 = var0.length - var4) == 0 || var8 > 2) {
            JStackCmd.usage();
            throw new IllegalArgumentException("The parameter is invalid.");
        }
        if (var8 == 2) {
            var1 = true;
        } else if (!var0[var4].matches("[0-9]+")) {
            var1 = true;
        }
        if (var1) {
            String[] var6 = new String[var8];
            for (int var7 = var4; var7 < var0.length; ++var7) {
                var6[var7 - var4] = var0[var7];
            }
            return JStackCmd.runJStackTool(var2, var3, var6);
        }
        String var9 = var0[var4];
        String[] var10 = var3 ? new String[]{"-l"} : new String[]{};
        return JStackCmd.runThreadDump(var9, var10);
    }

    private static JStackResult runJStackTool(boolean var0, boolean var1, String[] var2) throws Exception {
        if (var0) {
            var2 = JStackCmd.prepend("-m", var2);
        }
        if (var1) {
            var2 = JStackCmd.prepend("-l", var2);
        }
        JStackResult jStackResult = new JStackResult();
        JStackTool.init(var2, jStackResult);
        return jStackResult;
    }

    private static Class<?> loadSAClass() {
        try {
            return Class.forName("sun.jvm.hotspot.tools.JStack", true, ClassLoader.getSystemClassLoader());
        }
        catch (Exception var1) {
            return null;
        }
    }

    private static JStackResult runThreadDump(String var0, String[] var1) throws Exception {
        int var5;
        VirtualMachine var2 = null;
        try {
            var2 = VirtualMachine.attach(var0);
        }
        catch (Exception var7) {
            String var4 = var7.getMessage();
            if (var4 != null) {
                throw new AttachingException(var0 + ": " + var4);
            }
            if (var7 instanceof AttachNotSupportedException) {
                throw new AttachNotSupportedException("The -F option can be used when the target process is not responding");
            }
            throw var7;
        }
        InputStream var3 = ((HotSpotVirtualMachine)var2).remoteDataDump(var1);
        byte[] var8 = new byte[256];
        StringBuilder threadDump = new StringBuilder();
        do {
            if ((var5 = var3.read(var8)) <= 0) continue;
            String var6 = new String(var8, 0, var5, "UTF-8");
            threadDump.append(var6);
        } while (var5 > 0);
        JStackResult jStackResult = new JStackResult();
        jStackResult.setThreadDump(threadDump.toString());
        threadDump = null;
        var8 = null;
        var3.close();
        var2.detach();
        return jStackResult;
    }

    private static String[] prepend(String var0, String[] var1) {
        String[] var2 = new String[var1.length + 1];
        var2[0] = var0;
        System.arraycopy(var1, 0, var2, 1, var1.length);
        return var2;
    }

    private static void usage() {
        System.err.println("Usage:");
        System.err.println("    jstack [-l] <pid>");
        System.err.println("        (to connect to running process)");
        if (JStackCmd.loadSAClass() != null) {
            System.err.println("    jstack -F [-m] [-l] <pid>");
            System.err.println("        (to connect to a hung process)");
            System.err.println("    jstack [-m] [-l] <executable> <core>");
            System.err.println("        (to connect to a core file)");
            System.err.println("    jstack [-m] [-l] [server_id@]<remote server IP or hostname>");
            System.err.println("        (to connect to a remote debug server)");
        }
        System.err.println("");
        System.err.println("Options:");
        if (JStackCmd.loadSAClass() != null) {
            System.err.println("    -F  to force a thread dump. Use when jstack <pid> does not respond (process is hung)");
            System.err.println("    -m  to print both java and native frames (mixed mode)");
        }
        System.err.println("    -l  long listing. Prints additional information about locks");
        System.err.println("    -h or -help to print this help message");
    }
}

