/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole.tools.jstack;

import beifengtz.vmconsole.entity.jstack.JStackResult;
import beifengtz.vmconsole.exception.ConfigurationException;
import beifengtz.vmconsole.exception.NotAvailableException;
import beifengtz.vmconsole.exception.NotImplementedException;
import beifengtz.vmconsole.exception.UnInitException;
import beifengtz.vmconsole.exception.UnKnowException;
import beifengtz.vmconsole.tools.MyTool;
import beifengtz.vmconsole.tools.jstack.PStackTool;
import beifengtz.vmconsole.tools.jstack.StackTraceTool;
import java.io.IOException;
import java.io.PrintStream;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.JVMDebugger;

public class JStackTool
extends MyTool {
    private boolean mixedMode;
    private boolean concurrentLocks;
    private static boolean hasInit;
    private PrintStream ps;
    private JStackResult jStackResult;
    private int calledType;

    public JStackTool(boolean mixedMode, boolean concurrentLocks, PrintStream ps) {
        this.mixedMode = mixedMode;
        this.concurrentLocks = concurrentLocks;
        this.ps = ps;
        hasInit = true;
        this.calledType = 0;
    }

    public JStackTool(JVMDebugger d) {
        super(d);
    }

    public JStackTool(boolean mixedMode, boolean concurrentLocks, JStackResult jStackResult) {
        this.mixedMode = mixedMode;
        this.concurrentLocks = concurrentLocks;
        this.jStackResult = jStackResult;
        hasInit = true;
        this.calledType = 1;
    }

    @Override
    public boolean needsJavaPrefix() {
        return false;
    }

    @Override
    public String getName() {
        return "jstack";
    }

    @Override
    protected void printFlagsUsage() {
        System.out.println("    -l\tto print java.util.concurrent locks");
        System.out.println("    -m\tto print both java and native frames (mixed mode)");
        super.printFlagsUsage();
    }

    @Override
    public void run() {
        block18: {
            if (hasInit) {
                MyTool tool = null;
                if (this.mixedMode) {
                    tool = new PStackTool(false, this.concurrentLocks);
                    this.initTool(tool);
                    try {
                        if (this.calledType == 0) {
                            ((PStackTool)tool).run(this.ps);
                            break block18;
                        }
                        ((PStackTool)tool).run(this.jStackResult);
                    }
                    catch (NotAvailableException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (UnKnowException e) {
                        e.printStackTrace();
                    }
                    catch (ConfigurationException e) {
                        e.printStackTrace();
                    }
                    catch (NotImplementedException e) {
                        e.printStackTrace();
                    }
                } else {
                    tool = new StackTraceTool(false, this.concurrentLocks);
                    this.initTool(tool);
                    try {
                        if (this.calledType == 0) {
                            ((StackTraceTool)tool).run(this.ps);
                            break block18;
                        }
                        ((StackTraceTool)tool).run(this.jStackResult);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (UnKnowException e) {
                        e.printStackTrace();
                    }
                    catch (AddressException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    JStackTool.throwInitException();
                }
                catch (UnInitException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void throwInitException() throws UnInitException {
        throw new UnInitException("JStackTool have not initialized. The caller should call the init method first.");
    }

    public void initTool(MyTool tool) {
        tool.setAgent(this.getAgent());
        tool.setDebugeeType(this.getDebugeeType());
    }

    public static void init(String[] args) {
        JStackTool.init(args, System.out);
    }

    public static void init(String[] args, PrintStream ps) {
        hasInit = false;
        ToolArg toolArg = JStackTool.initDoFirst(args);
        JStackTool jstack = new JStackTool(toolArg.mixedMode, toolArg.concurrentLocks, ps);
        jstack.execute(toolArg.args, ps);
    }

    public static void init(String[] args, JStackResult jStackResult) throws Exception {
        hasInit = false;
        ToolArg toolArg = JStackTool.initDoFirst(args);
        JStackTool jstack = new JStackTool(toolArg.mixedMode, toolArg.concurrentLocks, jStackResult);
        jstack.execute(toolArg.args, jStackResult);
    }

    public static ToolArg initDoFirst(String[] args) {
        boolean mixedMode = false;
        boolean concurrentLocks = false;
        int used = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-m")) {
                mixedMode = true;
                ++used;
                continue;
            }
            if (!args[i].equals("-l")) continue;
            concurrentLocks = true;
            ++used;
        }
        if (used != 0) {
            String[] newArgs = new String[args.length - used];
            for (int i = 0; i < newArgs.length; ++i) {
                newArgs[i] = args[i + used];
            }
            args = newArgs;
        }
        return new ToolArg(mixedMode, concurrentLocks, args);
    }

    static class ToolArg {
        boolean mixedMode;
        boolean concurrentLocks;
        String[] args;

        public ToolArg(boolean mixedMode, boolean concurrentLocks, String[] args) {
            this.mixedMode = mixedMode;
            this.concurrentLocks = concurrentLocks;
            this.args = args;
        }
    }
}

