/*
 * Decompiled with CFR 0.152.
 */
package com.github.venth.failsafe.rxjava2.observation;

import com.github.venth.failsafe.rxjava2.observation.ObservationDeactivated;
import com.github.venth.failsafe.rxjava2.observation.ObservationState;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicReference;
import net.jodah.failsafe.CircuitBreaker;

public class CircuitBreakerObserver<T>
implements Observer<T>,
Disposable {
    private final AtomicReference<ObservationState<T>> state;

    public CircuitBreakerObserver(Observer<T> observer, CircuitBreaker circuitBreaker) {
        this.state = new AtomicReference<ObservationDeactivated<T>>(new ObservationDeactivated<T>(this, observer, circuitBreaker));
    }

    public void onSubscribe(Disposable disposable) {
        this.state.updateAndGet(state -> state.activate(disposable));
    }

    public void onNext(T t) {
        this.state.get().onNext(t);
    }

    public void onError(Throwable e) {
        this.state.get().onError(e);
    }

    public void onComplete() {
        this.state.get().onComplete();
    }

    public void dispose() {
        this.state.updateAndGet(ObservationState::dispose);
    }

    public boolean isDisposed() {
        return this.state.get().isDisposed();
    }
}

