/*
 * Decompiled with CFR 0.152.
 */
package com.github.venth.failsafe.rxjava2.observation;

import com.github.venth.failsafe.rxjava2.observation.ObservationDisposed;
import com.github.venth.failsafe.rxjava2.observation.ObservationState;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import net.jodah.failsafe.CircuitBreaker;

class ObservationActivated<T>
implements ObservationState<T> {
    private final Disposable disposable;
    private final Observer<T> observer;
    private final CircuitBreaker circuitBreaker;

    ObservationActivated(Disposable disposable, Observer<T> observer, CircuitBreaker circuitBreaker) {
        this.disposable = disposable;
        this.observer = observer;
        this.circuitBreaker = circuitBreaker;
    }

    @Override
    public ObservationState<T> activate(Disposable disposable) {
        return this;
    }

    @Override
    public void onNext(T t) {
        this.observer.onNext(t);
    }

    @Override
    public void onError(Throwable e) {
        this.circuitBreaker.recordFailure(e);
        this.observer.onError(e);
    }

    @Override
    public void onComplete() {
        this.circuitBreaker.recordSuccess();
        this.observer.onComplete();
    }

    @Override
    public ObservationState<T> dispose() {
        this.disposable.dispose();
        return new ObservationDisposed();
    }

    @Override
    public boolean isDisposed() {
        return false;
    }
}

