/*
 * Decompiled with CFR 0.152.
 */
package com.github.venth.failsafe.rxjava2.subscription;

import com.github.venth.failsafe.rxjava2.subscription.SubscriptionDeactivated;
import com.github.venth.failsafe.rxjava2.subscription.SubscriptionState;
import java.util.concurrent.atomic.AtomicReference;
import net.jodah.failsafe.CircuitBreaker;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class CircuitBreakerSubscriber<T>
implements Subscriber<T>,
Subscription {
    private final AtomicReference<SubscriptionState<T>> state;

    public CircuitBreakerSubscriber(Subscriber<? super T> subscriber, CircuitBreaker circuitBreaker) {
        this.state = new AtomicReference<SubscriptionDeactivated<T>>(new SubscriptionDeactivated<T>(this, subscriber, circuitBreaker));
    }

    public void onSubscribe(Subscription subscription) {
        this.state.updateAndGet(state -> state.activate(subscription));
    }

    public void onNext(T t) {
        this.state.get().onNext(t);
    }

    public void onError(Throwable err) {
        this.state.get().onError(err);
    }

    public void onComplete() {
        this.state.get().onComplete();
    }

    public void request(long n) {
        this.state.get().request(n);
    }

    public void cancel() {
        this.state.updateAndGet(SubscriptionState::cancel);
    }
}

