/*
 * Decompiled with CFR 0.152.
 */
package rufus.lzstring4java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class LZString {
    private static char[] keyStrBase64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static char[] keyStrUriSafe = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-$".toCharArray();
    private static HashMap<char[], HashMap<Character, Integer>> baseReverseDic = new HashMap();

    private static char getBaseValue(char[] alphabet, Character character) {
        return (char)baseReverseDic.get(alphabet).get(character).intValue();
    }

    public static String compressToBase64(String input) {
        if (input == null) {
            return "";
        }
        String res = LZString._compress(input, 6, new CompressFunctionWrapper(){

            @Override
            public Character doFunc(int a) {
                return Character.valueOf(keyStrBase64[a]);
            }
        });
        switch (res.length() % 4) {
            default: {
                return res;
            }
            case 1: {
                return res + "===";
            }
            case 2: {
                return res + "==";
            }
            case 3: 
        }
        return res + "=";
    }

    public static String decompressFromBase64(String inputStr) {
        if (inputStr == null) {
            return "";
        }
        if (inputStr == "") {
            return null;
        }
        final char[] input = inputStr.toCharArray();
        return LZString._decompress(input.length, 32, new DecompressFunctionWrapper(){

            @Override
            public Character doFunc(int index) {
                return Character.valueOf(LZString.getBaseValue(keyStrBase64, Character.valueOf(input[index])));
            }
        });
    }

    public static String compressToUTF16(String input) {
        if (input == null) {
            return "";
        }
        return LZString._compress(input, 15, new CompressFunctionWrapper(){

            @Override
            public Character doFunc(int a) {
                return LZString.fc(a + 32);
            }
        }) + " ";
    }

    public static String decompressFromUTF16(String compressedStr) {
        if (compressedStr == null) {
            return "";
        }
        if (compressedStr == "") {
            return null;
        }
        final char[] compressed = compressedStr.toCharArray();
        return LZString._decompress(compressed.length, 16384, new DecompressFunctionWrapper(){

            @Override
            public Character doFunc(int index) {
                return Character.valueOf((char)(compressed[index] - 32));
            }
        });
    }

    public static String compressToEncodedURIComponent(String input) {
        if (input == null) {
            return "";
        }
        return LZString._compress(input, 6, new CompressFunctionWrapper(){

            @Override
            public Character doFunc(int a) {
                return Character.valueOf(keyStrUriSafe[a]);
            }
        }) + " ";
    }

    public static String decompressFromEncodedURIComponent(String inputStr) {
        if (inputStr == null) {
            return "";
        }
        if (inputStr == "") {
            return null;
        }
        inputStr = inputStr.replace(' ', '+');
        final char[] input = inputStr.toCharArray();
        return LZString._decompress(input.length, 32, new DecompressFunctionWrapper(){

            @Override
            public Character doFunc(int index) {
                return Character.valueOf(LZString.getBaseValue(keyStrUriSafe, Character.valueOf(input[index])));
            }
        });
    }

    public static String compress(String uncompressed) {
        return LZString._compress(uncompressed, 16, new CompressFunctionWrapper(){

            @Override
            public Character doFunc(int a) {
                return LZString.fc(a);
            }
        });
    }

    private static String _compress(String uncompressedStr, int bitsPerChar, CompressFunctionWrapper getCharFromInt) {
        int value;
        int i;
        if (uncompressedStr == null) {
            return "";
        }
        HashMap<String, Integer> context_dictionary = new HashMap<String, Integer>();
        HashSet<String> context_dictionaryToCreate = new HashSet<String>();
        String context_c = "";
        String context_wc = "";
        String context_w = "";
        double context_enlargeIn = 2.0;
        int context_dictSize = 3;
        int context_numBits = 2;
        ArrayList<Character> context_data = new ArrayList<Character>(uncompressedStr.length() / 3);
        int context_data_val = 0;
        int context_data_position = 0;
        char[] uncompressed = uncompressedStr.toCharArray();
        for (int ii = 0; ii < uncompressed.length; ++ii) {
            context_c = String.valueOf(uncompressed[ii]);
            if (!context_dictionary.containsKey(context_c)) {
                context_dictionary.put(context_c, context_dictSize++);
                context_dictionaryToCreate.add(context_c);
            }
            if (context_dictionary.containsKey(context_wc = context_w + context_c)) {
                context_w = context_wc;
                continue;
            }
            if (context_dictionaryToCreate.contains(context_w)) {
                if (context_w.charAt(0) < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val <<= 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.add(getCharFromInt.doFunc(context_data_val));
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 8; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.add(getCharFromInt.doFunc(context_data_val));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = context_data_val << 1 | value;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.add(getCharFromInt.doFunc(context_data_val));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.add(getCharFromInt.doFunc(context_data_val));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                }
                if ((context_enlargeIn -= 1.0) == 0.0) {
                    context_enlargeIn = Math.pow(2.0, context_numBits);
                    ++context_numBits;
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                        context_data_position = 0;
                        context_data.add(getCharFromInt.doFunc(context_data_val));
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
            }
            if ((context_enlargeIn -= 1.0) == 0.0) {
                context_enlargeIn = Math.pow(2.0, context_numBits);
                ++context_numBits;
            }
            context_dictionary.put(context_wc, context_dictSize++);
            context_w = context_c;
        }
        if (!context_w.isEmpty()) {
            if (context_dictionaryToCreate.contains(context_w)) {
                if (context_w.charAt(0) < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val <<= 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.add(getCharFromInt.doFunc(context_data_val));
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 8; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.add(getCharFromInt.doFunc(context_data_val));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = context_data_val << 1 | value;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.add(getCharFromInt.doFunc(context_data_val));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.add(getCharFromInt.doFunc(context_data_val));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                }
                if ((context_enlargeIn -= 1.0) == 0.0) {
                    context_enlargeIn = Math.pow(2.0, context_numBits);
                    ++context_numBits;
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                        context_data_position = 0;
                        context_data.add(getCharFromInt.doFunc(context_data_val));
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
            }
            if ((context_enlargeIn -= 1.0) == 0.0) {
                context_enlargeIn = Math.pow(2.0, context_numBits);
                ++context_numBits;
            }
        }
        value = 2;
        for (i = 0; i < context_numBits; ++i) {
            context_data_val = context_data_val << 1 | value & 1;
            if (context_data_position == bitsPerChar - 1) {
                context_data_position = 0;
                context_data.add(getCharFromInt.doFunc(context_data_val));
                context_data_val = 0;
            } else {
                ++context_data_position;
            }
            value >>= 1;
        }
        while (true) {
            context_data_val <<= 1;
            if (context_data_position == bitsPerChar - 1) break;
            ++context_data_position;
        }
        context_data.add(getCharFromInt.doFunc(context_data_val));
        StringBuilder sb = new StringBuilder(context_data.size());
        Iterator iterator = context_data.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            sb.append(c);
        }
        return sb.toString();
    }

    public static String f(int i) {
        return String.valueOf((char)i);
    }

    public static Character fc(int i) {
        return Character.valueOf((char)i);
    }

    public static String decompress(final String compressed) {
        if (compressed == null) {
            return "";
        }
        if (compressed == "") {
            return null;
        }
        return LZString._decompress(compressed.length(), 32768, new DecompressFunctionWrapper(){
            char[] compChars;
            {
                this.compChars = compressed.toCharArray();
            }

            @Override
            public Character doFunc(int i) {
                return Character.valueOf(this.compChars[i]);
            }
        });
    }

    private static String _decompress(int length, int resetValue, DecompressFunctionWrapper getNextValue) {
        int resb;
        int power;
        ArrayList<String> dictionary = new ArrayList<String>();
        double enlargeIn = 4.0;
        int dictSize = 4;
        int numBits = 3;
        String entry = "";
        ArrayList<String> result = new ArrayList<String>();
        String c = null;
        DecData data = new DecData();
        data.val = getNextValue.doFunc(0).charValue();
        data.position = resetValue;
        data.index = 1;
        for (int i = 0; i < 3; ++i) {
            dictionary.add(i, LZString.f(i));
        }
        int bits = 0;
        int maxpower = (int)Math.pow(2.0, 2.0);
        for (power = 1; power != maxpower; power <<= 1) {
            resb = data.val & data.position;
            data.position >>= 1;
            if (data.position == 0) {
                data.position = resetValue;
                data.val = getNextValue.doFunc(data.index++).charValue();
            }
            bits |= (resb > 0 ? 1 : 0) * power;
        }
        int next = bits;
        switch (next) {
            case 0: {
                bits = 0;
                maxpower = (int)Math.pow(2.0, 8.0);
                for (power = 1; power != maxpower; power <<= 1) {
                    resb = data.val & data.position;
                    data.position >>= 1;
                    if (data.position == 0) {
                        data.position = resetValue;
                        data.val = getNextValue.doFunc(data.index++).charValue();
                    }
                    bits |= (resb > 0 ? 1 : 0) * power;
                }
                c = LZString.f(bits);
                break;
            }
            case 1: {
                bits = 0;
                maxpower = (int)Math.pow(2.0, 16.0);
                for (power = 1; power != maxpower; power <<= 1) {
                    resb = data.val & data.position;
                    data.position >>= 1;
                    if (data.position == 0) {
                        data.position = resetValue;
                        data.val = getNextValue.doFunc(data.index++).charValue();
                    }
                    bits |= (resb > 0 ? 1 : 0) * power;
                }
                c = LZString.f(bits);
                break;
            }
            case 2: {
                return "";
            }
        }
        dictionary.add(3, c);
        String w = c;
        result.add(w);
        while (data.index <= length) {
            bits = 0;
            maxpower = (int)Math.pow(2.0, numBits);
            for (power = 1; power != maxpower; power <<= 1) {
                resb = data.val & data.position;
                data.position >>= 1;
                if (data.position == 0) {
                    data.position = resetValue;
                    data.val = getNextValue.doFunc(data.index++).charValue();
                }
                bits |= (resb > 0 ? 1 : 0) * power;
            }
            int cc = bits;
            switch (cc) {
                case 0: {
                    bits = 0;
                    maxpower = (int)Math.pow(2.0, 8.0);
                    for (power = 1; power != maxpower; power <<= 1) {
                        resb = data.val & data.position;
                        data.position >>= 1;
                        if (data.position == 0) {
                            data.position = resetValue;
                            data.val = getNextValue.doFunc(data.index++).charValue();
                        }
                        bits |= (resb > 0 ? 1 : 0) * power;
                    }
                    dictionary.add(dictSize++, LZString.f(bits));
                    cc = dictSize - 1;
                    enlargeIn -= 1.0;
                    break;
                }
                case 1: {
                    bits = 0;
                    maxpower = (int)Math.pow(2.0, 16.0);
                    for (power = 1; power != maxpower; power <<= 1) {
                        resb = data.val & data.position;
                        data.position >>= 1;
                        if (data.position == 0) {
                            data.position = resetValue;
                            data.val = getNextValue.doFunc(data.index++).charValue();
                        }
                        bits |= (resb > 0 ? 1 : 0) * power;
                    }
                    dictionary.add(dictSize++, LZString.f(bits));
                    cc = dictSize - 1;
                    enlargeIn -= 1.0;
                    break;
                }
                case 2: {
                    StringBuilder sb = new StringBuilder(result.size());
                    for (String s : result) {
                        sb.append(s);
                    }
                    return sb.toString();
                }
            }
            if (enlargeIn == 0.0) {
                enlargeIn = Math.pow(2.0, numBits);
                ++numBits;
            }
            if (cc < dictionary.size() && dictionary.get(cc) != null) {
                entry = (String)dictionary.get(cc);
            } else if (cc == dictSize) {
                entry = w + w.charAt(0);
            } else {
                return null;
            }
            result.add(entry);
            dictionary.add(dictSize++, w + entry.charAt(0));
            w = entry;
            if ((enlargeIn -= 1.0) != 0.0) continue;
            enlargeIn = Math.pow(2.0, numBits);
            ++numBits;
        }
        return "";
    }

    static {
        for (char[] alphabet : new char[][]{keyStrBase64, keyStrUriSafe}) {
            HashMap<Character, Integer> map = baseReverseDic.get(alphabet);
            if (map != null) continue;
            map = new HashMap();
            baseReverseDic.put(alphabet, map);
            for (int i = 0; i < alphabet.length; ++i) {
                map.put(Character.valueOf(alphabet[i]), i);
            }
        }
    }

    protected static class DecData {
        public char val;
        public int position;
        public int index;

        protected DecData() {
        }
    }

    private static abstract class DecompressFunctionWrapper {
        private DecompressFunctionWrapper() {
        }

        public abstract Character doFunc(int var1);
    }

    private static abstract class CompressFunctionWrapper {
        private CompressFunctionWrapper() {
        }

        public abstract Character doFunc(int var1);
    }
}

