/*
 * Decompiled with CFR 0.152.
 */
package com.snail.network.utils;

import com.snail.java.network.converter.Converter;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003 !\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\bJ;\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007J1\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010\u001aJ)\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u001dJ%\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u001f\u00a8\u0006#"}, d2={"Lcom/snail/network/utils/HttpUtils;", "", "()V", "chooseTrustManager", "Ljavax/net/ssl/X509TrustManager;", "trustManagers", "", "Ljavax/net/ssl/TrustManager;", "([Ljavax/net/ssl/TrustManager;)Ljavax/net/ssl/X509TrustManager;", "convertObservable", "Lio/reactivex/Observable;", "T", "observable", "Lokhttp3/ResponseBody;", "converter", "Lcom/snail/java/network/converter/Converter;", "convertObservable$java", "getBaseUrl", "", "url", "getSslSocketFactory", "Lcom/snail/network/utils/HttpUtils$SSLParams;", "certificates", "Ljava/io/InputStream;", "bksFile", "password", "([Ljava/io/InputStream;Ljava/io/InputStream;Ljava/lang/String;)Lcom/snail/network/utils/HttpUtils$SSLParams;", "prepareKeyManager", "Ljavax/net/ssl/KeyManager;", "(Ljava/io/InputStream;Ljava/lang/String;)[Ljavax/net/ssl/KeyManager;", "prepareTrustManager", "([Ljava/io/InputStream;)[Ljavax/net/ssl/TrustManager;", "MyTrustManager", "SSLParams", "UnSafeTrustManager", "java"})
public final class HttpUtils {
    public static final HttpUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final SSLParams getSslSocketFactory(@Nullable InputStream[] certificates, @Nullable InputStream bksFile, @Nullable String password) {
        SSLParams sslParams = new SSLParams();
        try {
            TrustManager[] trustManagers = INSTANCE.prepareTrustManager(certificates);
            KeyManager[] keyManagers = INSTANCE.prepareKeyManager(bksFile, password);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            X509TrustManager trustManager = null;
            if (trustManagers != null) {
                X509TrustManager x509TrustManager = INSTANCE.chooseTrustManager(trustManagers);
                if (x509TrustManager == null) {
                    Intrinsics.throwNpe();
                }
                trustManager = new MyTrustManager(x509TrustManager);
            } else {
                trustManager = new UnSafeTrustManager();
            }
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
            SSLContext sSLContext = sslContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext, (String)"sslContext");
            sslParams.setSSLSocketFactory(sSLContext.getSocketFactory());
            sslParams.setTrustManager(trustManager);
            return sslParams;
        }
        catch (Exception e) {
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TrustManager[] prepareTrustManager(InputStream[] certificates) {
        block8: {
            block7: {
                if (certificates == null) break block7;
                InputStream[] inputStreamArray = certificates;
                boolean bl = false;
                if (!(inputStreamArray.length == 0)) break block8;
            }
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            InputStream[] inputStreamArray = certificates;
            int n = inputStreamArray.length;
            int n2 = 0;
            while (n2 < n) {
                void index;
                InputStream certificate = inputStreamArray[n2];
                String certificateAlias = Integer.toString((int)index);
                keyStore.setCertificateEntry(certificateAlias, certificateFactory.generateCertificate(certificate));
                try {
                    certificate.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++index;
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerFactory2, (String)"trustManagerFactory");
            return trustManagerFactory2.getTrustManagers();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final KeyManager[] prepareKeyManager(InputStream bksFile, String password) {
        try {
            if (bksFile == null || password == null) {
                return null;
            }
            KeyStore clientKeyStore = KeyStore.getInstance("BKS");
            String string = password;
            Object object = bksFile;
            Object object2 = clientKeyStore;
            boolean bl = false;
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] cArray2 = cArray;
            ((KeyStore)object2).load((InputStream)object, cArray2);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String string2 = password;
            object = clientKeyStore;
            object2 = keyManagerFactory;
            boolean bl2 = false;
            char[] cArray3 = string2.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray3, (String)"(this as java.lang.String).toCharArray()");
            cArray2 = cArray3;
            ((KeyManagerFactory)object2).init((KeyStore)object, cArray2);
            KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyManagerFactory2, (String)"keyManagerFactory");
            return keyManagerFactory2.getKeyManagers();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final X509TrustManager chooseTrustManager(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final String getBaseUrl(@NotNull String url) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        int index = StringsKt.indexOf$default((CharSequence)url, (String)"://", (int)0, (boolean)false, (int)6, null);
        String string2 = url;
        int n = index + 3;
        int n2 = 0;
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String subUrl = string3;
        String string4 = url;
        n2 = 0;
        int n3 = index + 3;
        boolean bl = false;
        String string5 = string4.substring(n2, n3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String urlHead = string5;
        index = StringsKt.indexOf$default((CharSequence)subUrl, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            string4 = subUrl;
            n2 = 0;
            StringBuilder stringBuilder = new StringBuilder().append(urlHead);
            n3 = 0;
            String string6 = string4;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n2, index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string8 = string7;
            string = stringBuilder.append(string8).toString();
        } else {
            string = url;
        }
        return string;
    }

    @NotNull
    public final <T> Observable<T> convertObservable$java(@NotNull Observable<ResponseBody> observable, @NotNull Converter<ResponseBody, T> converter) {
        Intrinsics.checkParameterIsNotNull(observable, (String)"observable");
        Intrinsics.checkParameterIsNotNull(converter, (String)"converter");
        Observable observable2 = observable.map(new Function<T, R>(converter){
            final /* synthetic */ Converter $converter;

            public final T apply(@NotNull ResponseBody it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$converter.convert(it);
            }
            {
                this.$converter = converter;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"observable.map { converter.convert(it) }");
        return observable2;
    }

    private HttpUtils() {
    }

    static {
        HttpUtils httpUtils;
        INSTANCE = httpUtils = new HttpUtils();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/snail/network/utils/HttpUtils$SSLParams;", "", "()V", "sSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getSSLSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "setSSLSocketFactory", "(Ljavax/net/ssl/SSLSocketFactory;)V", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "getTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "setTrustManager", "(Ljavax/net/ssl/X509TrustManager;)V", "java"})
    public static final class SSLParams {
        @Nullable
        private SSLSocketFactory sSLSocketFactory;
        @Nullable
        private X509TrustManager trustManager;

        @Nullable
        public final SSLSocketFactory getSSLSocketFactory() {
            return this.sSLSocketFactory;
        }

        public final void setSSLSocketFactory(@Nullable SSLSocketFactory sSLSocketFactory) {
            this.sSLSocketFactory = sSLSocketFactory;
        }

        @Nullable
        public final X509TrustManager getTrustManager() {
            return this.trustManager;
        }

        public final void setTrustManager(@Nullable X509TrustManager x509TrustManager) {
            this.trustManager = x509TrustManager;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ#\u0010\u000b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/snail/network/utils/HttpUtils$UnSafeTrustManager;", "Ljavax/net/ssl/X509TrustManager;", "()V", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "java"})
    public static final class UnSafeTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
            Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
            Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
        }

        @Override
        public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
            Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
            Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ#\u0010\r\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/snail/network/utils/HttpUtils$MyTrustManager;", "Ljavax/net/ssl/X509TrustManager;", "localTrustManager", "(Ljavax/net/ssl/X509TrustManager;)V", "defaultTrustManager", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "java"})
    private static final class MyTrustManager
    implements X509TrustManager {
        private final X509TrustManager defaultTrustManager;
        private final X509TrustManager localTrustManager;

        @Override
        public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
            Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
            Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
        }

        @Override
        public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
            Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
            Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
            try {
                X509TrustManager x509TrustManager = this.defaultTrustManager;
                if (x509TrustManager == null) {
                    Intrinsics.throwNpe();
                }
                x509TrustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ce) {
                this.localTrustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public MyTrustManager(@NotNull X509TrustManager localTrustManager) throws NoSuchAlgorithmException, KeyStoreException {
            Intrinsics.checkParameterIsNotNull((Object)localTrustManager, (String)"localTrustManager");
            this.localTrustManager = localTrustManager;
            TrustManagerFactory var4 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            var4.init((KeyStore)null);
            TrustManagerFactory trustManagerFactory = var4;
            Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerFactory, (String)"var4");
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerArray, (String)"var4.trustManagers");
            this.defaultTrustManager = INSTANCE.chooseTrustManager(trustManagerArray);
        }
    }
}

