/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.network.download;

import com.snail.java.network.TaskInfo;
import com.snail.java.network.TaskWorker;
import com.snail.java.network.callback.MultiTaskListener;
import com.snail.java.network.callback.TaskListener;
import com.snail.java.network.callback.TaskObserver;
import com.snail.java.network.download.DownloadInfo;
import com.snail.java.network.download.DownloadObserver;
import com.snail.java.network.download.DownloadService;
import com.snail.java.network.exception.RetryWhenException;
import com.snail.java.network.interceptor.ProgressInterceptor;
import com.snail.java.utils.IOUtils;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.internal.schedulers.IoScheduler;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\b\u0010\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B%\b\u0010\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\rJ\u0013\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0010\u001a\u00020\rJ\u0013\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/snail/java/network/download/DownloadWorker;", "T", "Lcom/snail/java/network/download/DownloadInfo;", "Lcom/snail/java/network/TaskWorker;", "info", "listener", "Lcom/snail/java/network/callback/TaskListener;", "(Lcom/snail/java/network/download/DownloadInfo;Lcom/snail/java/network/callback/TaskListener;)V", "infos", "", "Lcom/snail/java/network/callback/MultiTaskListener;", "(Ljava/util/List;Lcom/snail/java/network/callback/MultiTaskListener;)V", "execute", "", "(Lcom/snail/java/network/download/DownloadInfo;)V", "pause", "resume", "writeToDisk", "responseBody", "Lokhttp3/ResponseBody;", "file", "Ljava/io/File;", "(Lokhttp3/ResponseBody;Ljava/io/File;Lcom/snail/java/network/download/DownloadInfo;)V", "java"})
public final class DownloadWorker<T extends DownloadInfo>
extends TaskWorker<T, T> {
    @Override
    protected void execute(@NotNull T info) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        DownloadObserver<T> observer = new DownloadObserver<T>(info, this.getListener() == null ? null : new TaskWorker.LocalTaskListener(this));
        ((Map)this.getTaskMap()).put(info, observer);
        ProgressInterceptor interceptor = new ProgressInterceptor(observer);
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)interceptor).build();
        ((DownloadService)new Retrofit.Builder().client(client).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(((TaskInfo)info).getBaseUrl()).build().create(DownloadService.class)).download("bytes=" + ((TaskInfo)info).getCompletionLength() + "-", ((TaskInfo)info).getUrl()).retryWhen((Function)new RetryWhenException(0, 0L, 0L, 7, null)).map(new Function<T, R>(this, (DownloadInfo)info){
            final /* synthetic */ DownloadWorker this$0;
            final /* synthetic */ DownloadInfo $info;

            @NotNull
            public final T apply(@NotNull ResponseBody responseBody) {
                Intrinsics.checkParameterIsNotNull((Object)responseBody, (String)"responseBody");
                DownloadWorker.access$writeToDisk(this.this$0, responseBody, new File(this.$info.getTemporaryFilePath$java()), this.$info);
                return (T)this.$info;
            }
            {
                this.this$0 = downloadWorker;
                this.$info = downloadInfo;
            }
        }).subscribeOn((Scheduler)new IoScheduler()).subscribe((Observer)observer);
    }

    public final void pause() {
        Collection collection = this.getTaskMap().values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"taskMap.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskObserver it = (TaskObserver)element$iv;
            boolean bl = false;
            it.dispose(false);
        }
    }

    public final void pause(@NotNull T info) {
        block0: {
            Intrinsics.checkParameterIsNotNull(info, (String)"info");
            TaskObserver taskObserver = this.getTaskMap().get(info);
            if (taskObserver == null) break block0;
            taskObserver.dispose(false);
        }
    }

    public final void resume() {
        ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)this.getTaskMap().keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"taskMap.keys");
        Iterable $this$forEach$iv = keySetView;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            if (it.getState() != TaskInfo.State.PAUSE) continue;
            DownloadInfo downloadInfo = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)downloadInfo, (String)"it");
            this.execute((T)downloadInfo);
        }
    }

    public final void resume(@NotNull T info) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        if (((TaskInfo)info).getState() == TaskInfo.State.PAUSE) {
            this.execute(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeToDisk(ResponseBody responseBody, File file, T info) {
        if (responseBody == null) {
            return;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        InputStream inputStream = responseBody.byteStream();
        long allLength = ((TaskInfo)info).getContentLength() == 0L ? responseBody.contentLength() : ((TaskInfo)info).getContentLength();
        try {
            Closeable closeable = new RandomAccessFile(file, "rwd").getChannel();
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileChannel it = (FileChannel)closeable;
                boolean bl2 = false;
                MappedByteBuffer mappedBuffer = it.map(FileChannel.MapMode.READ_WRITE, ((TaskInfo)info).getCompletionLength(), allLength - ((TaskInfo)info).getCompletionLength());
                byte[] buffer = new byte[81920];
                int len = inputStream.read(buffer);
                while (len != -1) {
                    mappedBuffer.put(buffer, 0, len);
                    len = inputStream.read(buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public DownloadWorker(@NotNull T info, @Nullable TaskListener<T> listener) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        super((TaskInfo)info, listener);
    }

    public DownloadWorker(@NotNull List<? extends T> infos, @Nullable MultiTaskListener<T> listener) {
        Intrinsics.checkParameterIsNotNull(infos, (String)"infos");
        super(infos, listener);
    }

    public static final /* synthetic */ void access$writeToDisk(DownloadWorker $this, ResponseBody responseBody, File file, DownloadInfo info) {
        $this.writeToDisk(responseBody, file, info);
    }
}

