/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.network.upload;

import com.snail.java.network.callback.ProgressListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/snail/java/network/upload/ProgressRequestBody;", "Lokhttp3/RequestBody;", "contentType", "Lokhttp3/MediaType;", "file", "Ljava/io/File;", "listener", "Lcom/snail/java/network/callback/ProgressListener;", "(Lokhttp3/MediaType;Ljava/io/File;Lcom/snail/java/network/callback/ProgressListener;)V", "contentLength", "", "writeTo", "", "sink", "Lokio/BufferedSink;", "java"})
public final class ProgressRequestBody
extends RequestBody {
    private final MediaType contentType;
    private final File file;
    private final ProgressListener listener;

    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() {
        return this.file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        InputStream inputStream = null;
        long uploaded = 0L;
        try {
            byte[] buffer = new byte[50000];
            inputStream = new FileInputStream(this.file);
            int len = inputStream.read(buffer);
            while (len != -1) {
                sink.write(buffer, 0, len);
                uploaded += (long)len;
                ProgressListener progressListener = this.listener;
                if (progressListener != null) {
                    progressListener.onProgress(uploaded, this.contentLength());
                }
                len = inputStream.read(buffer);
            }
        }
        finally {
            Util.closeQuietly((Closeable)inputStream);
        }
    }

    public ProgressRequestBody(@Nullable MediaType contentType, @NotNull File file, @Nullable ProgressListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.contentType = contentType;
        this.file = file;
        this.listener = listener;
    }
}

