/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.utils;

import com.snail.java.utils.FileUtils;
import com.snail.java.utils.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lcom/snail/java/utils/ZipHelper;", "", "()V", "unzip", "Lcom/snail/java/utils/ZipHelper$UnzipExecutor;", "zip", "Lcom/snail/java/utils/ZipHelper$ZipExecutor;", "UnzipExecutor", "ZipExecutor", "java"})
public final class ZipHelper {
    public static final ZipHelper INSTANCE;

    @JvmStatic
    @NotNull
    public static final ZipExecutor zip() {
        return new ZipExecutor();
    }

    @JvmStatic
    @NotNull
    public static final UnzipExecutor unzip() {
        return new UnzipExecutor();
    }

    private ZipHelper() {
    }

    static {
        ZipHelper zipHelper;
        INSTANCE = zipHelper = new ZipHelper();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0007J\u0014\u0010\u0017\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/snail/java/utils/ZipHelper$ZipExecutor;", "", "()V", "comment", "", "files", "Ljava/util/ArrayList;", "Ljava/io/File;", "level", "", "method", "replace", "", "targetDir", "targetName", "addEntry", "", "base", "source", "zos", "Ljava/util/zip/ZipOutputStream;", "addSourceFile", "file", "addSourceFiles", "", "execute", "setComment", "setLevel", "setMethod", "setReplace", "setTarget", "dir", "filename", "java"})
    public static final class ZipExecutor {
        private String comment;
        private int method = -1;
        private int level = -1;
        private final ArrayList<File> files = new ArrayList();
        private String targetDir;
        private String targetName;
        private boolean replace;

        @NotNull
        public final ZipExecutor setComment(@NotNull String comment) {
            Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
            this.comment = comment;
            return this;
        }

        @NotNull
        public final ZipExecutor setMethod(int method) {
            if (method == 0 || method == 8) {
                this.method = method;
            }
            return this;
        }

        @NotNull
        public final ZipExecutor setLevel(int level) {
            this.level = level > 9 ? 9 : level;
            return this;
        }

        @NotNull
        public final ZipExecutor addSourceFile(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            if (file.exists() && !this.files.contains(file)) {
                this.files.add(file);
            }
            return this;
        }

        @NotNull
        public final ZipExecutor addSourceFiles(@NotNull List<? extends File> files) {
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            Collection collection = files;
            boolean bl = false;
            if (!collection.isEmpty()) {
                for (File file : files) {
                    this.addSourceFile(file);
                }
            }
            return this;
        }

        @NotNull
        public final ZipExecutor setTarget(@NotNull String dir, @NotNull String filename) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            this.targetDir = dir;
            this.targetName = filename;
            return this;
        }

        @NotNull
        public final ZipExecutor setReplace(boolean replace) {
            this.replace = replace;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        public final File execute() {
            CharSequence charSequence;
            ZipOutputStream zos;
            block24: {
                File file;
                File file2;
                if (this.files.isEmpty()) {
                    return null;
                }
                File zipFile = null;
                File file3 = this.files.get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"files[0]");
                File f = file3;
                if (this.targetDir == null) {
                    String string;
                    String string2 = f.getParent();
                    if (this.targetName == null) {
                        File file4 = f.getParentFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"f.parentFile");
                        string = file4.getName();
                    } else {
                        string = this.targetName;
                    }
                    file2 = new File(string2, Intrinsics.stringPlus((String)string, (Object)".zip"));
                } else {
                    String string;
                    if (this.targetName == null) {
                        File file5 = f.getParentFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"f.parentFile");
                        string = file5.getName();
                    } else {
                        string = this.targetName;
                    }
                    file2 = new File(this.targetDir, Intrinsics.stringPlus((String)string, (Object)".zip"));
                }
                zipFile = file2;
                File zipParentFile = zipFile.getParentFile();
                if (!zipParentFile.exists()) {
                    zipParentFile.mkdirs();
                }
                zos = null;
                try {
                    boolean first = true;
                    for (File file6 : this.files) {
                        if (first && zipFile.exists()) {
                            if (this.replace) {
                                if (!zipFile.delete()) {
                                    charSequence = null;
                                    break block24;
                                }
                            } else {
                                String path = zipFile.getAbsolutePath();
                                StringBuilder stringBuilder = new StringBuilder();
                                String string = path;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                                String newName = stringBuilder.append(FileUtils.getFileNameWithoutSuffix(string)).append(System.currentTimeMillis()).append(FileUtils.getSuffix(path)).toString();
                                zipFile = new File(zipFile.getParent(), newName);
                            }
                        }
                        if (zos == null) {
                            zos = new ZipOutputStream(new FileOutputStream(zipFile));
                            if (this.level > 0) {
                                zos.setLevel(this.level);
                            }
                            if (this.comment != null) {
                                String string = this.comment;
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                charSequence = string;
                                boolean bl = false;
                                if (charSequence.length() == 0) {
                                    zos.setComment(this.comment);
                                }
                            }
                            if (this.method > 0) {
                                zos.setMethod(this.method);
                            }
                        }
                        File file7 = file6;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"file");
                        this.addEntry("", file7, zos);
                        first = false;
                    }
                    file = zipFile;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        file = null;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(zos);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(zos);
                    return file;
                }
                IOUtils.closeQuietly(zos);
                return file;
            }
            IOUtils.closeQuietly(zos);
            return charSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void addEntry(String base, File source2, ZipOutputStream zos) throws IOException {
            String basePath = base;
            basePath = basePath + source2.getName();
            if (source2.isDirectory()) {
                File[] files = source2.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = 0;
                    File[] fileArray2 = fileArray;
                    int n2 = 0;
                    if (!(fileArray2.length == 0)) {
                        fileArray2 = files;
                        n2 = fileArray2.length;
                        n = 0;
                        while (n < n2) {
                            File file = fileArray2[n];
                            String string = basePath + '/';
                            File file2 = file;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                            this.addEntry(string, file2, zos);
                            ++n;
                        }
                        return;
                    }
                }
                ZipOutputStream zipOutputStream = zos;
                if (zipOutputStream == null) {
                    Intrinsics.throwNpe();
                }
                zipOutputStream.putNextEntry(new ZipEntry(basePath + '/'));
                return;
            }
            BufferedInputStream bis = null;
            try {
                ZipOutputStream zipOutputStream = zos;
                if (zipOutputStream == null) {
                    Intrinsics.throwNpe();
                }
                zipOutputStream.putNextEntry(new ZipEntry(basePath));
                byte[] buffer = new byte[10240];
                bis = new BufferedInputStream(new FileInputStream(source2), buffer.length);
                int read = bis.read(buffer, 0, buffer.length);
                while (read != -1) {
                    zos.write(buffer, 0, read);
                    read = bis.read(buffer, 0, buffer.length);
                }
                zos.closeEntry();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
            IOUtils.closeQuietly(bis);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0007J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/snail/java/utils/ZipHelper$UnzipExecutor;", "", "()V", "targetDir", "", "zipFiles", "Ljava/util/ArrayList;", "Ljava/io/File;", "addZipFile", "zipFile", "addZipFiles", "", "execute", "", "setTargetDir", "java"})
    public static final class UnzipExecutor {
        private final ArrayList<File> zipFiles = new ArrayList();
        private String targetDir;

        @NotNull
        public final UnzipExecutor addZipFile(@NotNull File zipFile) {
            Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
            if (zipFile.exists() && !this.zipFiles.contains(zipFile)) {
                this.zipFiles.add(zipFile);
            }
            return this;
        }

        @NotNull
        public final UnzipExecutor addZipFiles(@NotNull List<? extends File> zipFiles) {
            Intrinsics.checkParameterIsNotNull(zipFiles, (String)"zipFiles");
            Collection collection = zipFiles;
            boolean bl = false;
            if (!collection.isEmpty()) {
                for (File file : zipFiles) {
                    this.addZipFile(file);
                }
            }
            return this;
        }

        @NotNull
        public final UnzipExecutor setTargetDir(@NotNull String targetDir) {
            Intrinsics.checkParameterIsNotNull((Object)targetDir, (String)"targetDir");
            this.targetDir = targetDir;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final boolean execute() {
            if (this.zipFiles.isEmpty()) {
                return false;
            }
            var2_1 = this.zipFiles.iterator();
            while (true) {
                if (!var2_1.hasNext()) {
                    return true;
                }
                source = var2_1.next();
                zis = null;
                bos = null;
                try {
                    zis = new ZipInputStream(new FileInputStream(source));
                    entry = zis.getNextEntry();
lbl14:
                    // 2 sources

                    while (entry != null) {
                        if (this.targetDir == null) {
                            v0 = source;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"source");
                            v1 = new File(v0.getParent(), entry.getName());
                        } else {
                            v1 = target = new File(this.targetDir, entry.getName());
                        }
                        if (target.getParentFile().exists() || target.getParentFile().mkdirs()) ** GOTO lbl-1000
                        var7_11 = false;
                        ** GOTO lbl33
                    }
                    ** GOTO lbl46
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        var6_9 = false;
                    }
                    catch (Throwable var5_7) {
                        IOUtils.closeQuietly(new Closeable[]{zis, bos});
                        throw var5_7;
                    }
lbl33:
                    // 1 sources

                    IOUtils.closeQuietly(new Closeable[]{zis, bos});
                    return var7_11;
lbl-1000:
                    // 1 sources

                    {
                        if (!entry.isDirectory()) {
                            bos = new BufferedOutputStream(new FileOutputStream(target));
                            buffer = new byte[10240];
                            read = zis.read(buffer, 0, buffer.length);
                            while (read != -1) {
                                bos.write(buffer, 0, read);
                                read = zis.read(buffer, 0, buffer.length);
                            }
                            bos.flush();
                        }
                        entry = zis.getNextEntry();
                        ** GOTO lbl14
lbl46:
                        // 1 sources

                        zis.closeEntry();
                    }
                    IOUtils.closeQuietly(new Closeable[]{zis, bos});
                    continue;
                    IOUtils.closeQuietly(new Closeable[]{zis, bos});
                    return var6_9;
                }
                break;
            }
        }
    }
}

