/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tH\u0007J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tH\u0007J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\bH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\bH\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\bH\u0007J\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\n\u0010\u0016\u001a\u00020\u0014\"\u00020\u0017H\u0007J!\u0010\u0018\u001a\u00020\b2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0019\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u001aJ \u0010\u001b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0004H\u0007\u00a8\u0006%"}, d2={"Lcom/snail/java/utils/MathUtils;", "", "()V", "bytesToInt", "", "bigEndian", "", "src", "", "", "bytesToLong", "", "bytesToShort", "", "calcCRC16_Modbus", "data", "calcCRC_CCITT_0xFFFF", "bytes", "calcCRC_CCITT_XModem", "getPercents", "", "scale", "values", "", "joinPackage", "", "([[B)[B", "numberToBytes", "value", "len", "reverseBitAndByte", "setDoubleAccuracy", "", "num", "splitPackage", "", "size", "library"})
public final class MathUtils {
    public static final MathUtils INSTANCE;

    @JvmStatic
    public static final double setDoubleAccuracy(double num, int scale) {
        return (double)((int)(num * Math.pow(10.0, scale))) / Math.pow(10.0, scale);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final float[] getPercents(int scale, float ... values) {
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        float total = 0.0f;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int n = 0;
        int n2 = values.length;
        while (n < n2) {
            void i;
            if (values[i] != 0.0f) {
                list.add((int)i);
            }
            total += values[i];
            ++i;
        }
        if (total == 0.0f) {
            return new float[values.length];
        }
        float[] fs = new float[values.length];
        int sc = (int)Math.pow(10.0, scale + 2);
        float sum = 0.0f;
        int n3 = 0;
        int n4 = ((Collection)list).size();
        while (n3 < n4) {
            void i;
            Object e = list.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"list[i]");
            int index = ((Number)e).intValue();
            if (i == list.size() - 1) {
                fs[index] = 1.0f - sum;
            } else {
                fs[index] = (float)((int)(values[index] / total * (float)sc)) / (float)sc;
                sum += fs[index];
            }
            ++i;
        }
        return fs;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] numberToBytes(boolean bigEndian, long value, int len) {
        byte[] byArray;
        byte[] bytes = new byte[8];
        int n = 0;
        int n2 = 7;
        while (n <= n2) {
            void i;
            void j = bigEndian ? 7 - i : i;
            bytes[i] = (byte)(value >> 8 * j & 0xFFL);
            ++i;
        }
        if (len > 8) {
            byArray = bytes;
        } else {
            byte[] byArray2 = Arrays.copyOfRange(bytes, bigEndian ? 8 - len : 0, bigEndian ? 8 : len);
            byArray = byArray2;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Arrays.copyOfRange(bytes\u2026f (bigEndian) 8 else len)");
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final long bytesToLong(boolean bigEndian, byte ... src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        int len = Math.min(8, src.length);
        byte[] bs = new byte[8];
        System.arraycopy(src, 0, bs, bigEndian ? 8 - len : 0, len);
        long value = 0L;
        int n = 0;
        int n2 = 7;
        while (n <= n2) {
            void i;
            int shift = (bigEndian ? 7 - i : i) << 3;
            value |= (long)255 << shift & (long)bs[i] << shift;
            ++i;
        }
        return src.length == 1 ? (long)((byte)value) : (src.length == 2 ? (long)((short)value) : (src.length <= 4 ? (long)((int)value) : value));
    }

    @JvmStatic
    public static final int bytesToInt(boolean bigEndian, byte ... src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        return (int)MathUtils.bytesToLong(bigEndian, Arrays.copyOf(src, src.length));
    }

    @JvmStatic
    public static final short bytesToShort(boolean bigEndian, byte ... src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        return (short)MathUtils.bytesToLong(bigEndian, Arrays.copyOf(src, src.length));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] reverseBitAndByte(@NotNull byte[] src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        byte[] byArray = src;
        int n = 0;
        if (byArray.length == 0) {
            return src;
        }
        byte[] target = new byte[src.length];
        n = 0;
        int n2 = src.length;
        while (n < n2) {
            void i;
            int value = 0;
            int tmp = src[src.length - 1 - i];
            int n3 = 7;
            boolean bl = false;
            while (n3 >= 0) {
                void j;
                value |= (tmp & 1) << j;
                tmp >>= 1;
                --j;
            }
            target[i] = (byte)value;
            ++i;
        }
        return target;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<byte[]> splitPackage(@NotNull byte[] src, int size) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int loopCount = src.length / size + (src.length % size == 0 ? 0 : 1);
        int n = 0;
        int n2 = loopCount;
        while (n < n2) {
            void j;
            void from = j * size;
            int to = Math.min(src.length, (int)(from + size));
            list.add(Arrays.copyOfRange(src, (int)(j * size), to));
            ++j;
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final byte[] joinPackage(byte[] ... src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        byte[] bytes = new byte[]{};
        for (byte[] bs : src) {
            byte[] byArray = bytes;
            int n = bytes.length + bs.length;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.copyOf(byArray, n), (String)"java.util.Arrays.copyOf(this, newSize)");
            System.arraycopy(bs, 0, bytes, bytes.length - bs.length, bs.length);
        }
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int calcCRC16_Modbus(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int crc = 65535;
        for (byte b : data) {
            crc = b < 0 ? crc ^ b + 256 : crc ^ b;
            int n = 8;
            int n2 = 1;
            while (n >= n2) {
                void i;
                if ((crc & 1) != 0) {
                    crc >>= 1;
                    crc ^= 0xA001;
                } else {
                    crc >>= 1;
                }
                --i;
            }
        }
        return crc;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int calcCRC_CCITT_XModem(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        int crc = 0;
        int polynomial = 4129;
        for (byte b : bytes) {
            int n = 0;
            int n2 = 7;
            while (n <= n2) {
                void i;
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (c15 ^ bit) {
                    crc ^= polynomial;
                }
                ++i;
            }
        }
        return crc &= 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int calcCRC_CCITT_0xFFFF(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        int crc = 65535;
        int polynomial = 4129;
        for (byte b : bytes) {
            int n = 0;
            int n2 = 7;
            while (n <= n2) {
                void i;
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (c15 ^ bit) {
                    crc ^= polynomial;
                }
                ++i;
            }
        }
        return crc &= 0xFFFF;
    }

    private MathUtils() {
    }

    static {
        MathUtils mathUtils;
        INSTANCE = mathUtils = new MathUtils();
    }
}

