/*
 * Decompiled with CFR 0.152.
 */
package com.weebkun.api;

import com.google.gson.Gson;
import com.squareup.moshi.Moshi;
import com.weebkun.api.Options;
import com.weebkun.api.Repository;
import com.weebkun.api.TokenType;
import com.weebkun.api.User;
import com.weebkun.auth.OAuth;
import com.weebkun.utils.AlreadyAuthenticatedException;
import com.weebkun.utils.HttpErrorException;
import com.weebkun.utils.NotAuthenticatedException;
import com.weebkun.utils.ParamConflictException;
import com.weebkun.utils.UnauthorisedException;
import java.io.IOException;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class Github {
    private static String token;
    private static TokenType type;
    private static final String ROOT = "https://api.github.com";
    private static OkHttpClient client;
    private static String USER_AGENT;
    private static final Gson GSON;
    private static final Moshi moshi;
    public static final String gsonMediaType = "application/json; charset=utf-8";

    public static void authenticate(String clientId, String[] scopes) throws AlreadyAuthenticatedException {
        if (token != null) {
            throw new AlreadyAuthenticatedException();
        }
        OAuth.authenticate(clientId, scopes);
        token = OAuth.getToken();
    }

    public static void authenticate(String token) throws AlreadyAuthenticatedException {
        if (Github.token != null) {
            throw new AlreadyAuthenticatedException();
        }
        Github.token = token;
    }

    public static Builder init() {
        return new Builder();
    }

    public static void setClient(OkHttpClient client) {
        Github.client = client;
    }

    public static OkHttpClient getClient() {
        return client;
    }

    public static String getRoot() {
        return ROOT;
    }

    public static Gson getGson() {
        return GSON;
    }

    public static Moshi getMoshi() {
        return moshi;
    }

    public static void setAgent(String agent) {
        USER_AGENT = agent;
    }

    public static User getAuthenticatedUser() throws NotAuthenticatedException, HttpErrorException {
        Request request = new Request.Builder().url("https://api.github.com/user").build();
        User user = null;
        try (Response response = client.newCall(request).execute();){
            if (response.code() == 401) {
                throw new NotAuthenticatedException("error: user not authenticated.\nauthenticate using Github.authenticate() first.");
            }
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            user = (User)moshi.adapter(User.class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return user;
    }

    public static Repository[] listUserRepos(Options params) throws ParamConflictException, HttpErrorException {
        if (params.perPage > 100) {
            throw new IndexOutOfBoundsException("results per page exceeds 100.");
        }
        if (params.before != null && params.since != null) {
            throw new ParamConflictException("since and before used together.");
        }
        Request request = new Request.Builder().url(ROOT + "/user/repos".concat(params.visibility != null ? String.format("?visibility=%s&", params.visibility) : "").concat(params.affiliation != null ? String.format("affiliation=%s&", params.affiliation) : "").concat(params.type != null ? String.format("type=%s&", params.type) : "").concat(params.sort != null ? String.format("sort=%s&", params.sort) : "").concat(params.direction != null ? String.format("direction=%s&", params.direction) : "").concat(params.perPage != 0 ? String.format("per_page=%d&", params.perPage) : "").concat(params.page != 0 ? String.format("page=%d&", params.page) : "").concat(params.since != null ? String.format("since=%s", params.since) : "").concat(params.since == null && params.before != null ? String.format("before=%s", params.before) : "")).build();
        Repository[] repositories = new Repository[]{};
        try (Response response = client.newCall(request).execute();){
            if (response.code() == 422) {
                throw new ParamConflictException(String.format("error: type conflict: %s\n%s\n\n%s", response.code() + " " + response.message(), response.headers(), response.body()));
            }
            if (response.code() == 401) {
                throw new UnauthorisedException(response);
            }
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            repositories = (Repository[])GSON.fromJson(response.body().string(), Repository[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return repositories;
    }

    static {
        client = new OkHttpClient();
        USER_AGENT = "Java-github-api";
        GSON = new Gson();
        moshi = new Moshi.Builder().build();
        client.newBuilder().addInterceptor(new Interceptor(){

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
                return chain.proceed(chain.request().newBuilder().addHeader("accept", "application/vnd.github.v3+json").addHeader("accept", "application/vnd.github.mercy-preview+json").addHeader("accept", "application/vnd.github.nebula-preview+json").addHeader("user-agent", USER_AGENT).addHeader("authorization", String.format("%s %s", type == TokenType.OAUTH ? "token" : "basic", token)).build());
            }
        });
    }

    public static final class Builder {
        private final OkHttpClient.Builder builder = new OkHttpClient.Builder();

        public Builder addInterceptor(Interceptor interceptor) {
            this.builder.addInterceptor(interceptor);
            return this;
        }

        public Builder addNetworkInterceptor(Interceptor interceptor) {
            this.builder.addNetworkInterceptor(interceptor);
            return this;
        }

        public Builder addEventListener(EventListener listener) {
            this.builder.eventListener(listener);
            return this;
        }

        public Builder addEventListenerFactory(EventListener.Factory factory) {
            this.builder.eventListenerFactory(factory);
            return this;
        }

        public void build() {
            client = this.builder.build();
        }
    }
}

