/*
 * Decompiled with CFR 0.152.
 */
package com.weebkun.api;

import com.weebkun.api.Github;
import com.weebkun.api.Options;
import com.weebkun.api.Plan;
import com.weebkun.api.Repository;
import com.weebkun.utils.HttpErrorException;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Organisation {
    public String login;
    private int id;
    private String node_id;
    public String url;
    public String repos_url;
    public String events_url;
    public String hooks_url;
    public String issues_url;
    public String members_url;
    public String public_members_url;
    public String avatar_url;
    public String description;
    public String name;
    public String company;
    public String blog;
    public String location;
    public String email;
    public String twitter_username;
    public boolean is_verified;
    public boolean has_organisation_projects;
    public boolean has_repository_projects;
    public int public_repos;
    public int public_gists;
    public int followers;
    public int following;
    public String html_url;
    public String created_at;
    public String updated_at;
    public String type = "Organization";
    public int total_private_repos;
    public int owned_private_repos;
    public int private_gists;
    public int disk_usage;
    public int collaborators;
    public String billing_email;
    public Plan plan;
    public String default_repository_permission;
    public boolean members_can_create_repositories;
    public boolean two_factor_requirement_enabled;
    public String members_allowed_repository_creation_type;
    public boolean members_can_create_public_repositories;
    public boolean members_can_create_private_repositories;
    public boolean members_can_create_internal_repositories;
    public boolean members_can_create_pages;

    public static Repository[] getRepos(String org, Options params) {
        if (params.perPage > 100) {
            throw new IndexOutOfBoundsException("results per page exceeds 100.");
        }
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/orgs/%s/repos".concat(params.type != null ? String.format("?type=%s&", params.type) : "").concat(params.sort != null ? String.format("sort=%s&", params.sort) : "").concat(params.direction != null ? String.format("direction=%s&", params.direction) : "").concat(params.perPage != 0 ? String.format("per_page=%d&", params.perPage) : "").concat(params.page != 0 ? String.format("page=%d", params.page) : ""), org)).build();
        Repository[] repositories = new Repository[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            repositories = (Repository[])Github.getGson().fromJson(response.body().string(), Repository[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return repositories;
    }

    public Repository[] getRepos(Options params) {
        return Organisation.getRepos(this.name, params);
    }

    public static void createRepo(String org, String json) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/orgs/%s/repos", org)).post(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 201) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createRepo(String json) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/orgs/%s/repos", this.name)).post(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 201) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final class OrgBuilder
    extends Repository.Builder {
        public String org;
        public int teamId;

        @Override
        public void build() throws HttpErrorException {
            String json = String.format("{'name':'%s''description': '%s''homepage': '%s''private': '%s''visibility': '%s''has_issues': '%s''has_projects': '%s''has_wiki': '%s''is_template': '%s''team_id': '%s''auto_init': '%s''gitignore_template': '%s'license_template': '%s''allow_squash_merge': '%s''allow_merge_commit': '%s''allow_rebase_merge': '%s''delete_branch_on_merge': '%s'}", this.name, this.description, this.homepage, this.isPrivate, this.visibility, this.hasIssues, this.hasProjects, this.hasWiki, this.isTemplate, this.teamId, this.autoInit, this.gitignoreTemplate, this.licenseTemplate, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.deleteBranchOnMerge);
            Organisation.createRepo(this.org, json);
        }
    }
}

