/*
 * Decompiled with CFR 0.152.
 */
package com.weebkun.auth;

import com.squareup.moshi.JsonAdapter;
import com.weebkun.api.Github;
import com.weebkun.auth.AuthenticationStatus;
import com.weebkun.auth.ResponseDeviceCode;
import com.weebkun.auth.TokenResponse;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OAuth {
    private static boolean authorised = false;
    private static String token;

    public static void authenticate(String clientId, String[] scopes) {
        String json = String.format("{'client_id': '%s','scope': '%s'}", clientId, String.join((CharSequence)" ", scopes));
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url("https://github.com/login/device/code").post(body).build();
        while (!authorised) {
            try {
                Response response = Github.getClient().newCall(request).execute();
                try {
                    JsonAdapter adapter = Github.getMoshi().adapter(ResponseDeviceCode.class);
                    ResponseDeviceCode res = (ResponseDeviceCode)adapter.fromJson(response.body().source());
                    System.out.printf("go to %s for verification. the code is %s\n", res.verification_uri, res.user_code);
                    AuthenticationStatus status = OAuth.poll(clientId, res.device_code);
                    if (status == AuthenticationStatus.success) {
                        return;
                    }
                    if (status != AuthenticationStatus.expired_token) continue;
                    OAuth.authenticate(clientId, scopes);
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (IOException | NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AuthenticationStatus poll(String clientId, String code) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String json = String.format("{'client_id': '%s','device_code': '%s''grant_type': 'urn:ietf:params:oauth:grant-type:device_code'}", clientId, code);
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url("https://github.com/login/oauth/access_token").post(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            JsonAdapter adapter = Github.getMoshi().adapter(TokenResponse.class);
            TokenResponse res = (TokenResponse)adapter.fromJson(response.body().source());
            if (res.access_token != null) {
                token = res.access_token;
                authorised = true;
                AuthenticationStatus authenticationStatus2 = AuthenticationStatus.success;
                return authenticationStatus2;
            }
            System.err.println(res.error);
            authorised = false;
            if (res.error.equals("authorization_pending")) {
                OAuth.poll(clientId, code);
            }
            AuthenticationStatus authenticationStatus = AuthenticationStatus.expired_token;
            return authenticationStatus;
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
            return AuthenticationStatus.success;
        }
    }

    public static boolean isAuthorised() {
        return authorised;
    }

    public static String getToken() {
        return token;
    }
}

