/*
 * Decompiled with CFR 0.152.
 */
package com.weebkun.auth;

import com.squareup.moshi.JsonAdapter;
import com.weebkun.auth.AuthenticationStatus;
import com.weebkun.auth.ResponseDeviceCode;
import com.weebkun.auth.TokenResponse;
import com.weebkun.github.Github;
import com.weebkun.utils.HttpErrorException;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OAuth {
    private static boolean authorised = false;
    private static String token;
    private static OkHttpClient client;

    public static void authenticate(String clientId, String[] scopes) {
        String code = OAuth.sendRequest(clientId, scopes);
        AuthenticationStatus status = OAuth.poll(clientId, code);
        while (!authorised) {
            status = OAuth.poll(clientId, code);
        }
    }

    private static String sendRequest(String clientId, String[] scopes) {
        String json = String.format("{\"client_id\": \"%s\",\"scope\": \"%s\"}", clientId, String.join((CharSequence)" ", scopes));
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url("https://github.com/login/device/code").post(body).build();
        String code = "";
        try (Response response = client.newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            JsonAdapter adapter = Github.getMoshi().adapter(ResponseDeviceCode.class);
            ResponseDeviceCode res = (ResponseDeviceCode)adapter.fromJson(response.body().source());
            System.out.printf("go to %s for verification. the code is %s\n", res.verification_uri, res.user_code);
            code = res.device_code;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return code;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AuthenticationStatus poll(String clientId, String code) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String json = String.format("{\"client_id\": \"%s\",\"device_code\": \"%s\",\"grant_type\": \"urn:ietf:params:oauth:grant-type:device_code\"}", clientId, code);
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url("https://github.com/login/oauth/access_token").post(body).build();
        try (Response response = client.newCall(request).execute();){
            JsonAdapter adapter = Github.getMoshi().adapter(TokenResponse.class);
            TokenResponse res = (TokenResponse)adapter.fromJson(response.body().source());
            if (res.access_token != null) {
                token = res.access_token;
                authorised = true;
                AuthenticationStatus authenticationStatus = AuthenticationStatus.success;
                return authenticationStatus;
            }
            System.err.println(res.error);
            authorised = false;
            if (res.error.equals("authorization_pending")) {
                AuthenticationStatus authenticationStatus = OAuth.poll(clientId, code);
                return authenticationStatus;
            }
            AuthenticationStatus authenticationStatus = AuthenticationStatus.expired_token;
            return authenticationStatus;
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
            return AuthenticationStatus.success;
        }
    }

    public static boolean isAuthorised() {
        return authorised;
    }

    public static String getToken() {
        return token;
    }

    static {
        client = new OkHttpClient();
        client = client.newBuilder().addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("accept", "application/json").build())).build();
    }
}

