/*
 * Decompiled with CFR 0.152.
 */
package com.weebkun.github;

import com.squareup.moshi.Moshi;
import com.weebkun.github.Github;
import com.weebkun.utils.HttpErrorException;
import com.weebkun.utils.UnauthorisedException;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class Network {
    private final OkHttpClient client;
    private final Moshi moshi = Github.getMoshi();

    protected Network(OkHttpClient client) {
        this.client = client;
    }

    protected <T> T get(String endPoint, Class<T> type) {
        Object result;
        Request request = new Request.Builder().url(Github.getRoot() + endPoint).build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            result = this.moshi.adapter(type).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
        return (T)result;
    }

    protected void post(String endPoint, String json) {
        Request request = new Request.Builder().url(Github.getRoot() + endPoint).post(RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"))).build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.code() != 201) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void put(String endPoint, String json) {
        Request request = new Request.Builder().url(Github.getRoot() + endPoint).put(RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"))).build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.code() != 204) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void patch(String endPoint, String json) {
        Request request = new Request.Builder().url(Github.getRoot() + endPoint).patch(RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"))).build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.code() == 403) {
                throw new UnauthorisedException(response);
            }
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void delete(String endPoint) {
        Request request = new Request.Builder().url(Github.getRoot() + endPoint).delete().build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.code() != 204) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void delete(String endPoint, String json) {
        Request request = new Request.Builder().url(Github.getRoot() + endPoint).delete(RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"))).build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.code() != 204) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

