/*
 * Decompiled with CFR 0.152.
 */
package com.weebkun.github;

import com.squareup.moshi.Json;
import com.weebkun.github.Branch;
import com.weebkun.github.Content;
import com.weebkun.github.File;
import com.weebkun.github.Github;
import com.weebkun.github.Language;
import com.weebkun.github.License;
import com.weebkun.github.Owner;
import com.weebkun.github.Tag;
import com.weebkun.github.Team;
import com.weebkun.github.User;
import com.weebkun.utils.HttpErrorException;
import com.weebkun.utils.UnauthorisedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Repository {
    private int id;
    private String node_id;
    public String name;
    public String full_name;
    public Owner owner;
    @Json(name="private")
    public boolean is_private;
    public String html_url;
    public String description;
    public boolean fork;
    public License license;
    public Owner organization;
    public String url;
    public String forks_url;
    public String keys_url;
    public String collaborators_url;
    public String teams_url;
    public String hooks_url;
    public String issue_events_url;
    public String events_url;
    public String assignees_url;
    public String branches_url;
    public String tags_url;
    public String blobs_url;
    public String git_tags_url;
    public String git_refs_url;
    public String trees_url;
    public String statuses_url;
    public String languages_url;
    public String stargazers_url;
    public String contributors_url;
    public String subscribers_url;
    public String subscription_url;
    public String commits_url;
    public String git_commits_url;
    public String comments_url;
    public String issue_comment_url;
    public String contents_url;
    public String compare_url;
    public String merges_url;
    public String archive_url;
    public String downloads_url;
    public String issues_url;
    public String pulls_url;
    public String milestones_url;
    public String notifications_url;
    public String labels_url;
    public String releases_url;
    public String deployments_url;
    public String pushed_at;
    public String created_at;
    public String updated_at;
    public String git_url;
    public String ssh_url;
    public String clone_url;
    public String svn_url;
    public String homepage;
    public int size;
    public int stargazers_count;
    public int watchers_count;
    public String language;
    public boolean has_issues;
    public boolean has_projects;
    public boolean has_downloads;
    public boolean has_wiki;
    public boolean has_pages;
    public int forks_count;
    public String mirror_url;
    public int open_issues_count;
    public int forks;
    public int open_issues;
    public boolean is_template;
    public String[] topics;
    public int watchers;
    public String default_branch;
    public int network_count;
    public int subscribers_count;
    public boolean archived;
    public boolean disabled;
    public String visibility;
    public Permissions permissions;
    public boolean allow_rebase_merge;
    public Repository template_repository;
    public String temp_clone_token;
    public boolean allow_squash_merge;
    public boolean delete_branch_on_merge;
    public boolean allow_merge_commit;
    public Repository parent;
    public Repository source;

    public int getId() {
        return this.id;
    }

    public String getNodeId() {
        return this.node_id;
    }

    public static Repository get(String owner, String name) throws UnauthorisedException {
        return Github.getNetworkUtil().get(String.format("/repos/%s/%s", owner, name), Repository.class);
    }

    public static Repository[] getAllPublic(String since, int perPage, String visibility) {
        if (perPage > 100) {
            throw new IndexOutOfBoundsException("results per page exceeds 100.");
        }
        return Github.getNetworkUtil().get(String.format("/repositories?since=%s&per_page=%d&visibility=%s", since, perPage, visibility), Repository[].class);
    }

    public static void create(String templateOwner, String templateName, String owner, String name, String description, boolean isPrivate) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)String.format("{\"owner\": \"%s\",\"name\": \"%s\",\"description\": \"%s\",\"private\": \"%s\"}", owner, name, description, isPrivate), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/generate", templateOwner, templateName)).post(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 201) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getEndPoint(String endPoint) {
        return String.format("/repos/%s/%s/%s", this.owner.getName(), this.name, endPoint);
    }

    public void delete() throws UnauthorisedException {
        Github.getNetworkUtil().delete(String.format("/repos/%s/%s", this.owner.getName(), this.name));
    }

    public Adapter adapter() {
        return new Adapter(this.owner.getName()).setName(this.name).setDescription(this.description).setHomepage(this.homepage).setPrivate(this.is_private).setVisibility(this.visibility).setIssues(this.has_issues).setProjects(this.has_projects).setWiki(this.has_wiki).setDownloads(this.has_downloads).setTemplate(this.is_template).setDefaultBranch(this.default_branch).setSquashMerge(this.allow_squash_merge).setMergeCommit(this.allow_merge_commit).setRebaseMerge(this.allow_rebase_merge).setDeleteBranchOnMerge(this.delete_branch_on_merge).setArchived(this.archived);
    }

    public Branch[] listBranches() {
        return this.listBranches(0, 0);
    }

    public Branch[] listBranches(int page, int perPage) {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/branches", this.owner.getName(), this.name).concat(page != 0 ? String.format("?page=%d", page) : "").concat(perPage != 0 ? String.format("&per_page=%d", perPage) : "")).build();
        Branch[] branches = new Branch[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            branches = (Branch[])Github.getMoshi().adapter(Branch[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return branches;
    }

    public Branch[] listBranches(boolean isProtected) {
        return this.listBranches(isProtected, 0, 0);
    }

    public Branch[] listBranches(boolean isProtected, int page, int perPage) {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/branches", this.owner.getName(), this.name).concat(isProtected ? String.format("?protected=%s", isProtected) : "").concat(page != 0 ? String.format("&page=%d", page) : "").concat(perPage != 0 ? String.format("&per_page=%d", perPage) : "")).build();
        Branch[] branches = new Branch[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            branches = (Branch[])Github.getMoshi().adapter(Branch[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return branches;
    }

    public Branch getBranch(String name) {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/branches/%s", this.owner.getName(), this.name, name)).build();
        Branch branch = null;
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            branch = (Branch)Github.getMoshi().adapter(Branch.class).fromJson(response.body().source());
            branch.repo = this.name;
            branch.owner = this.owner.getName();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return branch;
    }

    public boolean areDependencyAlertsEnabled() {
        boolean bl;
        block8: {
            Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/vulnerability-alerts", this.owner.getName(), this.name)).build();
            Response response = Github.getClient().newCall(request).execute();
            try {
                boolean bl2 = bl = response.code() == 204;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    public void updateDependencyAlerts(boolean enabled) {
        if (enabled) {
            Github.getNetworkUtil().put(String.format("/repos/%s/%s/vulnerability-alerts", this.owner.getName(), this.name), "");
        } else {
            Github.getNetworkUtil().delete(String.format("/repos/%s/%s/vulnerability-alerts", this.owner.getName(), this.name));
        }
    }

    public Content getContent(String path) throws HttpErrorException {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/contents/%s", this.owner.getName(), this.name, path)).build();
        Content content = null;
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            content = (Content)Github.getMoshi().adapter(Content.class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public Content[] getAllContent() throws HttpErrorException {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/contents", this.owner.getName(), this.name)).build();
        Content[] contents = new Content[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            contents = (Content[])Github.getMoshi().adapter(Content[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contents;
    }

    public Content[] getDirectory(String path) throws HttpErrorException {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/contents/%s", this.owner.getName(), this.name, path)).build();
        Content[] contents = new Content[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            contents = (Content[])Github.getMoshi().adapter(Content[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contents;
    }

    public File getFile(String path) throws HttpErrorException {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/contents/%s", this.owner.getName(), this.name, path)).build();
        File file = null;
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            file = (File)Github.getMoshi().adapter(File.class).fromJson(response.body().source());
            file.owner = this.owner.getName();
            file.repo = this.name;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public String getReadMe() {
        return this.getReadMe("master");
    }

    public String getReadMe(String ref) throws HttpErrorException {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/readme?ref=%s", this.owner.getName(), this.name, ref)).build();
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("accept", "application/vnd.github.v3.html").build())).build();
        String html = null;
        try (Response response = client.newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            File file = (File)Github.getMoshi().adapter(File.class).fromJson(response.body().source());
            html = new String(Base64.getDecoder().decode(file.content));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return html;
    }

    public String getReadMeRaw() {
        return this.getReadMeRaw("master");
    }

    public String getReadMeRaw(String ref) {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/readme?ref=%s", this.owner.getName(), this.name, ref)).build();
        OkHttpClient client = Github.getClient().newBuilder().addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("accept", "application/vnd.github.v3.raw").build())).build();
        String raw = null;
        try (Response response = client.newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            File file = (File)Github.getMoshi().adapter(File.class).fromJson(response.body().source());
            raw = new String(Base64.getDecoder().decode(file.content));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return raw;
    }

    public void createFile(String path, String message, InputStream file) throws IOException, HttpErrorException {
        this.createFile(path, message, file, "master");
    }

    public void createFile(String path, String message, InputStream file, String branch) throws IOException, HttpErrorException {
        String json = "{" + String.format("\"message\": \"%s\"", message) + String.format("\"content\": \"%s\"", Base64.getEncoder().encodeToString(file.readAllBytes())) + String.format("\"branch\": \"%s\"", branch) + "}";
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/contents/%s", this.owner, this.name, path)).put(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 201) {
                throw new HttpErrorException(response);
            }
        }
    }

    public User[] getContributors(boolean includeAnonymous, int resultsPerPage, int page) {
        return Github.getNetworkUtil().get(String.format("/repos/%s/%s/contributors?anon=%s&per_page=%d&page=%d", this.owner.getName(), this.name, includeAnonymous, resultsPerPage, page), User[].class);
    }

    public User[] getContributors(boolean includeAnonymous) {
        return Github.getNetworkUtil().get(String.format("/repos/%s/%s/contributors?anon=%s", this.owner.getName(), this.name, includeAnonymous), User[].class);
    }

    public User[] getContributors() {
        return this.getContributors(true);
    }

    public Language listLanguages() {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/languages", this.owner.getName(), this.name)).build();
        Language languages = null;
        try (Response response = Github.getClient().newCall(request).execute();){
            languages = (Language)Github.getMoshi().adapter(Language.class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return languages;
    }

    public Tag[] listTags() {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/tags", this.owner.getName(), this.name)).build();
        Tag[] tags = new Tag[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            tags = (Tag[])Github.getMoshi().adapter(Tag[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tags;
    }

    public Tag[] listTags(int resultsPerPage, int page) {
        if (resultsPerPage > 100) {
            throw new IndexOutOfBoundsException("results per page exceeds 100.");
        }
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/tags?per_page=%d&page=%d", this.owner.getName(), this.name, resultsPerPage, page)).build();
        Tag[] tags = new Tag[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            tags = (Tag[])Github.getMoshi().adapter(Tag[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tags;
    }

    public Team[] listTeams() {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/teams", this.owner.getName(), this.name)).build();
        Team[] teams = new Team[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            teams = (Team[])Github.getMoshi().adapter(Team[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return teams;
    }

    public Team[] listTeams(int resultsPerPage, int page) {
        if (resultsPerPage > 100) {
            throw new IndexOutOfBoundsException("results per page exceeds 100.");
        }
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/teams?per_page=%d&page=%d", this.owner.getName(), this.name, resultsPerPage, page)).build();
        Team[] teams = new Team[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            teams = (Team[])Github.getMoshi().adapter(Team[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return teams;
    }

    public void replaceTopics(String[] topics) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)String.format("{\"names\": %s}", Github.getMoshi().adapter(String[].class).toJson((Object)topics)), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/topics", this.owner.getName(), this.name)).put(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void transfer(String newOwnerName, int[] teamIds) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)String.format("{\"new_owner\": \"%s\",\"team_ids\": \"%s\"}", newOwnerName, Github.getMoshi().adapter(int[].class).toJson((Object)teamIds)), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/transfer", this.owner.getName(), this.name)).post(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 202) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void transfer(String newOwnerName) throws HttpErrorException {
        Github.getNetworkUtil().post(String.format("/repos/%s/%s/transfer", this.owner.getName(), this.name), String.format("{\"new_owner\": \"%s\"}", newOwnerName));
    }

    public Repository[] getForks() {
        return Github.getNetworkUtil().get(this.getEndPoint("forks"), Repository[].class);
    }

    public String toJson() {
        return Github.getMoshi().adapter(Repository.class).toJson((Object)this);
    }

    public static class Adapter {
        private final transient String owner;
        protected String name;
        protected String description;
        protected String homepage;
        @Json(name="private")
        protected boolean isPrivate = false;
        protected String visibility = "public";
        protected boolean has_issues = true;
        protected boolean has_projects = true;
        protected boolean has_wiki = true;
        protected Boolean has_downloads = true;
        protected boolean is_template;
        protected String default_branch;
        protected boolean allow_squash_merge = true;
        protected boolean allow_merge_commit = true;
        protected boolean allow_rebase_merge = true;
        protected boolean delete_branch_on_merge = false;
        protected boolean auto_init = false;
        protected String gitignore_template;
        protected String license_template;
        protected Boolean archived;

        protected Adapter(String owner) {
            this.owner = owner;
        }

        public Adapter setName(String name) {
            this.name = name;
            return this;
        }

        public Adapter setDescription(String description) {
            this.description = description;
            return this;
        }

        public Adapter setHomepage(String homepage) {
            this.homepage = homepage;
            return this;
        }

        public Adapter setPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public Adapter setVisibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public Adapter setIssues(boolean hasIssues) {
            this.has_issues = hasIssues;
            return this;
        }

        public Adapter setProjects(boolean hasProjects) {
            this.has_projects = hasProjects;
            return this;
        }

        public Adapter setWiki(boolean hasWiki) {
            this.has_wiki = hasWiki;
            return this;
        }

        public Adapter setDownloads(Boolean hasDownloads) {
            this.has_downloads = hasDownloads;
            return this;
        }

        public Adapter setTemplate(boolean isTemplate) {
            this.is_template = isTemplate;
            return this;
        }

        public Adapter setDefaultBranch(String branch) {
            this.default_branch = branch;
            return this;
        }

        public Adapter setSquashMerge(boolean squashMerge) {
            this.allow_squash_merge = squashMerge;
            return this;
        }

        public Adapter setMergeCommit(boolean mergeCommit) {
            this.allow_merge_commit = mergeCommit;
            return this;
        }

        public Adapter setRebaseMerge(boolean rebaseMerge) {
            this.allow_rebase_merge = rebaseMerge;
            return this;
        }

        public Adapter setDeleteBranchOnMerge(boolean deleteBranchOnMerge) {
            this.delete_branch_on_merge = deleteBranchOnMerge;
            return this;
        }

        public Adapter setAutoInit(boolean autoInit) {
            this.auto_init = autoInit;
            return this;
        }

        public Adapter setGitignoreTemplate(String gitignoreTemplate) {
            this.gitignore_template = gitignoreTemplate;
            return this;
        }

        public Adapter setLicenseTemplate(String licenseTemplate) {
            this.license_template = licenseTemplate;
            return this;
        }

        public Adapter setArchived(Boolean archived) {
            this.archived = archived;
            return this;
        }

        public void update() {
            Github.getNetworkUtil().patch(String.format("/repos/%s/%s", this.owner, this.name), Github.getMoshi().adapter(Adapter.class).nonNull().toJson((Object)this.setGitignoreTemplate(null).setLicenseTemplate(null)));
        }
    }

    public static class Permissions {
        public boolean pull;
        public boolean push;
        public boolean admin;
    }

    public static class DeployKey {
        public int id;
        public String key;
        public String url;
        public String title;
        public boolean verified;
        public String created_at;
        public boolean read_only;
    }
}

