/*
 * Decompiled with CFR 0.152.
 */
package com.api.json;

import com.api.json.JSONArray;
import com.api.json.JSONArtifact;
import com.api.json.JSONObject;
import com.api.json.JSONStreamTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;

public class JSON
implements Serializable {
    private static final long serialVersionUID = 6529512794958410259L;
    public static String BLANKS = "   ";
    public static String BLANKSTR = "                                                            ";
    protected static boolean ESCAPE_SOLIDUS = true;
    private static final char BSP = '\b';
    private static final char CLN = ':';
    private static final char CMA = ',';
    private static final char DQTE = '\"';
    private static final char FFD = '\f';
    public static int INCR = BLANKS.length();
    private static final char LBKT = '[';
    private static final char LBRC = '{';
    private static int LN_CNTR = 0;
    private static int LN_OFFSET = 1;
    private static final char RBKT = ']';
    private static final char RBRC = '}';
    private static final char SPC = ' ';
    private static final char TAB = '\t';

    protected static String cleanUpString(Object obj) {
        if (obj == null) {
            return null;
        }
        String str = obj.toString();
        str = str.replace("\\", "\\\\");
        if (ESCAPE_SOLIDUS) {
            str = str.replace("/", "\\/");
        }
        str = str.replaceAll("\"", Matcher.quoteReplacement("\\\""));
        str = str.replace("\n", "\\n");
        str = str.replace("\r", "\\r");
        str = str.replace("\t", "\\t");
        str = JSON.expandUnicode(str);
        return str;
    }

    private static Object doArray(JSONStreamTokenizer jtok, Integer[] location) throws IOException {
        JSONArray array = new JSONArray();
        boolean keepGoing = true;
        block5: while (keepGoing) {
            int tokType = JSON.getNextToken(jtok, location);
            switch (tokType) {
                case -1: {
                    throw new IOException("Unterminated object on line " + location[LN_CNTR] + ", column " + location[LN_OFFSET]);
                }
                case 10: {
                    location[JSON.LN_CNTR] = location[LN_CNTR] + 1;
                    location[JSON.LN_OFFSET] = 0;
                    continue block5;
                }
                case 93: {
                    keepGoing = false;
                    continue block5;
                }
            }
            JSON.doPushBack(jtok, location);
            Object nextObj = JSON.recurseParser(jtok, location);
            array.add(nextObj);
            tokType = JSON.getNextToken(jtok, location);
            if (tokType == -1) continue;
            if (tokType == 10) {
                location[JSON.LN_CNTR] = location[LN_CNTR] + 1;
                location[JSON.LN_OFFSET] = 0;
                continue;
            }
            if (tokType == 125) {
                keepGoing = false;
                continue;
            }
            if (tokType == 93) {
                JSON.doPushBack(jtok, location);
                continue;
            }
            if (tokType == 44) continue;
            throw new IOException("Array missing comma delimiter in line " + location[LN_CNTR] + ", column " + location[LN_OFFSET]);
        }
        return array;
    }

    private static Object doObject(JSONStreamTokenizer jtok, Integer[] location) throws IOException {
        JSONObject jobj = new JSONObject();
        boolean keepGoing = true;
        block5: while (keepGoing) {
            int tokType = JSON.getNextToken(jtok, location);
            switch (tokType) {
                case -1: {
                    throw new IOException("Underminated object on line " + location[LN_CNTR] + ", column " + location[LN_OFFSET]);
                }
                case 10: {
                    location[JSON.LN_CNTR] = location[LN_CNTR] + 1;
                    location[JSON.LN_OFFSET] = 0;
                    continue block5;
                }
                case 125: {
                    keepGoing = false;
                    continue block5;
                }
            }
            JSON.doPushBack(jtok, location);
            Object key = JSON.recurseParser(jtok, location);
            if (key == null) {
                throw new IOException("Expecting string key on line " + location[LN_CNTR] + ", column " + location[LN_OFFSET]);
            }
            if (jtok.ttype == -1) continue;
            if (key instanceof String || key instanceof Number || key instanceof Boolean) {
                tokType = JSON.getNextToken(jtok, location);
                if (tokType != 58) {
                    throw new IOException("Expected ':'; found: " + tokType + " on line " + location[LN_CNTR] + ", column " + location[LN_OFFSET]);
                }
                Object value = JSON.recurseParser(jtok, location);
                jobj.put(key.toString(), value);
                tokType = JSON.getNextToken(jtok, location);
                if (tokType == -1) continue;
                if (tokType == 10) {
                    location[JSON.LN_CNTR] = location[LN_CNTR] + 1;
                    location[JSON.LN_OFFSET] = 0;
                    continue;
                }
                if (tokType == 125) {
                    JSON.doPushBack(jtok, location);
                    continue;
                }
                if (tokType == 44) continue;
                System.out.println("Error at: " + jtok.ttype + " for " + jtok.sval);
                throw new IOException("Missing comma delimiter on line " + location[LN_CNTR] + ", column " + location[LN_OFFSET]);
            }
            throw new IOException("Expecting string key on line " + location[LN_CNTR] + ", column " + location[LN_OFFSET]);
        }
        return jobj;
    }

    private static void doPushBack(JSONStreamTokenizer jtok, Integer[] location) throws IOException {
        if (location[LN_OFFSET] > 0) {
            location[JSON.LN_OFFSET] = location[LN_OFFSET] - 1;
        }
        jtok.pushBack();
    }

    private static Object doValue(JSONStreamTokenizer jtok, Integer[] location) {
        location[JSON.LN_OFFSET] = location[LN_OFFSET] + jtok.sval.length();
        if (jtok.ttype == 34) {
            return jtok.sval;
        }
        String test = jtok.sval;
        try {
            Double dTest = Double.valueOf(test);
            return JSON.getNumber(dTest, test);
        }
        catch (Exception exception) {
            if (test.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (test.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (test.equals("null")) {
                return null;
            }
            return test;
        }
    }

    public static void escapeSolidus(boolean set) {
        ESCAPE_SOLIDUS = set;
    }

    protected static String expandUnicode(String input) {
        StringBuffer sb = new StringBuffer();
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch < '\u0100') {
                sb.append(ch);
                continue;
            }
            if (ch < '\u1000') {
                sb.append("\\u0" + Integer.toHexString(ch));
                continue;
            }
            sb.append("\\u" + Integer.toHexString(ch));
        }
        return sb.toString();
    }

    private static int getNextToken(JSONStreamTokenizer jtok, Integer[] location) throws IOException {
        JSON.skipWhitespace(jtok, location);
        location[JSON.LN_OFFSET] = location[LN_OFFSET] + 1;
        return jtok.nextToken();
    }

    protected static Object getNumber(Double dNum, String value) {
        if (value.indexOf(46) >= 0) {
            return dNum;
        }
        Long lNum = dNum.longValue();
        if (dNum - lNum.doubleValue() != 0.0) {
            return dNum;
        }
        return lNum;
    }

    private static boolean isJSONable(Object object) {
        if (object == null) {
            return true;
        }
        return object instanceof String || object instanceof Boolean || object instanceof Number || object instanceof JSONArtifact;
    }

    public static boolean isValidObject(Object object) {
        return JSON.isJSONable(object);
    }

    public static boolean isValidType(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Class is null");
        }
        return clazz.getName().equals(String.class.getName()) || clazz.getName().equals(Boolean.class.getName()) || clazz.getName().equals(Integer.class.getName()) || clazz.getName().equals(Double.class.getName()) || clazz.getName().equals(Long.class.getName()) || clazz.getName().equals(Byte.class.getName()) || clazz.getName().equals(Short.class.getName()) || clazz.getName().equals(Float.class.getName()) || clazz.getName().equals(JSONObject.class.getName()) || clazz.getName().equals(JSONArray.class.getName());
    }

    public static JSONArtifact parse(InputStream is) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        return JSON.parse(r);
    }

    public static JSONArtifact parse(Reader reader) throws IOException {
        JSONStreamTokenizer jtok = new JSONStreamTokenizer(reader);
        Object jobj = new JSONObject();
        jtok.resetSyntax();
        jtok.wordChars(59, 90);
        jtok.wordChars(94, 122);
        jtok.wordChars(124, 124);
        jtok.wordChars(33, 33);
        jtok.wordChars(35, 38);
        jtok.wordChars(126, 126);
        jtok.wordChars(40, 32);
        jtok.wordChars(45, 57);
        jtok.eolIsSignificant(true);
        jtok.quoteChar(34);
        jtok.whitespaceChars(9, 9);
        jtok.whitespaceChars(12, 12);
        jtok.whitespaceChars(8, 8);
        Integer[] location = new Integer[2];
        location[JSON.LN_CNTR] = 1;
        location[JSON.LN_OFFSET] = 0;
        jobj = JSON.recurseParser(jtok, location);
        return (JSONArtifact)jobj;
    }

    public static JSONArtifact parse(String str) throws IOException {
        if (str == null) {
            throw new NullPointerException("str cannot be null");
        }
        return JSON.parse(new StringReader(str));
    }

    private static Object recurseParser(JSONStreamTokenizer jtok, Integer[] location) throws IOException {
        int tokType = JSON.getNextToken(jtok, location);
        switch (tokType) {
            case -3: {
                return JSON.doValue(jtok, location);
            }
            case -2: {
                return JSON.doValue(jtok, location);
            }
            case 91: {
                return JSON.doArray(jtok, location);
            }
            case 123: {
                return JSON.doObject(jtok, location);
            }
            case 34: {
                return JSON.doValue(jtok, location);
            }
            case -1: {
                return null;
            }
        }
        throw new IOException("Unexpected character [" + (char)tokType + "] while scanning JSON String for JSON type.  Invalid JSON. See line " + location[LN_CNTR] + ", column " + location[LN_OFFSET]);
    }

    public static void setSpacing(int size) {
        if (size < 1) {
            size = 1;
        } else if (size > 60) {
            size = 60;
        }
        INCR = size;
        BLANKS = BLANKSTR.substring(0, size);
    }

    private static int skipWhitespace(JSONStreamTokenizer jtok, Integer[] location) throws IOException {
        int tokType = jtok.nextToken();
        while (tokType == 32) {
            location[JSON.LN_OFFSET] = location[LN_OFFSET] + 1;
            tokType = jtok.nextToken();
        }
        JSON.doPushBack(jtok, location);
        return tokType;
    }
}

