/*
 * Decompiled with CFR 0.152.
 */
package com.api.json;

import com.api.json.JSON;
import com.api.json.JSONArtifact;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiFunction;

public class JSONObject
extends HashMap<String, Object>
implements JSONArtifact {
    private static final long serialVersionUID = -3778496643896012786L;

    public static boolean isValidObject(Object object) {
        return JSON.isValidObject(object);
    }

    public static boolean isValidType(Class<?> clazz) {
        return JSON.isValidType(clazz);
    }

    public static JSONObject parse(InputStream is) throws IOException {
        return (JSONObject)JSON.parse(is);
    }

    public static JSONObject parse(Reader reader) throws IOException {
        return (JSONObject)JSON.parse(reader);
    }

    public static JSONObject parse(String input) throws IOException {
        return (JSONObject)JSON.parse(input);
    }

    @Override
    public Object merge(String key, Object value, BiFunction<Object, Object, Object> remappingFunction) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (value != null && !JSONObject.isValidType(value.getClass())) {
            throw new IllegalArgumentException("Invalid type of value.  Type: [" + value.getClass().getName() + "] with value: [" + value + "]");
        }
        if (value instanceof Number) {
            value = JSON.getNumber(((Number)value).doubleValue(), value.toString());
        }
        return super.merge(key, value, remappingFunction);
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (value == this) {
            throw new IllegalArgumentException("Can not put an object into itself.");
        }
        if (value != null && !JSONObject.isValidType(value.getClass())) {
            throw new IllegalArgumentException("Invalid type of value.  Type: [" + value.getClass().getName() + "] with value: [" + value + "]");
        }
        if (value instanceof Number) {
            value = JSON.getNumber(((Number)value).doubleValue(), value.toString());
        }
        return super.put(key == null ? null : key.toString(), value);
    }

    @Override
    public void putAll(Map m) {
        for (Object key : m.keySet()) {
            if (key == null) {
                throw new IllegalArgumentException("key must not be null");
            }
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("key must be a String");
            }
            Object value = m.get(key);
            if (value != null && !JSONObject.isValidType(value.getClass())) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + value.getClass().getName() + "] with value: [" + value + "]");
            }
            if (value == this) {
                throw new IllegalArgumentException("Can not put an object into itself.");
            }
            if (value instanceof Number) {
                value = JSON.getNumber(((Number)value).doubleValue(), value.toString());
            }
            super.put(key == null ? null : key.toString(), value);
        }
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        Object test;
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (value != null && !JSONObject.isValidType(value.getClass())) {
            throw new IllegalArgumentException("Invalid type of value.  Type: [" + value.getClass().getName() + "] with value: [" + value + "]");
        }
        if (value == this) {
            throw new IllegalArgumentException("Can not put an object into itself.");
        }
        if (value instanceof Number) {
            value = JSON.getNumber(((Number)value).doubleValue(), value.toString());
        }
        if ((test = this.get(key)) != null) {
            return test;
        }
        super.put(key == null ? null : key.toString(), value);
        return null;
    }

    @Override
    public Object replace(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (value != null && !JSONObject.isValidType(value.getClass())) {
            throw new IllegalArgumentException("Invalid type of value.  Type: [" + value.getClass().getName() + "] with value: [" + value + "]");
        }
        if (!this.containsKey(key)) {
            return null;
        }
        Object test = this.get(key);
        if (value == this) {
            throw new IllegalArgumentException("Can not put an object into itself.");
        }
        if (value instanceof Number) {
            value = JSON.getNumber(((Number)value).doubleValue(), value.toString());
        }
        super.put(key == null ? null : key.toString(), value);
        return test;
    }

    @Override
    public boolean replace(String key, Object oldValue, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (value != null && !JSONObject.isValidType(value.getClass())) {
            throw new IllegalArgumentException("Invalid type of value.  Type: [" + value.getClass().getName() + "] with value: [" + value + "]");
        }
        if (!this.containsKey(key)) {
            return false;
        }
        Object test = this.get(key);
        if (test == null && oldValue != null) {
            return false;
        }
        if (!test.equals(oldValue)) {
            return false;
        }
        if (value == this) {
            throw new IllegalArgumentException("Can not put an object into itself.");
        }
        if (value instanceof Number) {
            value = JSON.getNumber(((Number)value).doubleValue(), value.toString());
        }
        super.put(key == null ? null : key.toString(), value);
        return true;
    }

    @Override
    public String serialize() throws IOException {
        return this.toString();
    }

    @Override
    public String serialize(boolean verbose) throws IOException {
        if (verbose) {
            StringBuffer sb = new StringBuffer();
            return this.toString(sb, 0, JSON.INCR);
        }
        return this.toString();
    }

    @Override
    public void serialize(OutputStream os) throws IOException {
        if (os == null) {
            throw new NullPointerException("OutputStream is null.");
        }
        os.write(this.toString().getBytes("UTF8"));
    }

    @Override
    public void serialize(OutputStream os, boolean verbose) throws IOException {
        if (os == null) {
            throw new NullPointerException("OutputStream is null.");
        }
        StringBuffer sb = new StringBuffer();
        os.write(this.toString(sb, 0, JSON.INCR).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        if (writer == null) {
            throw new NullPointerException("Writer is null.");
        }
        writer.write(this.toString());
    }

    @Override
    public void serialize(Writer writer, boolean verbose) throws IOException {
        if (writer == null) {
            throw new NullPointerException("Writer is null.");
        }
        StringBuffer sb = new StringBuffer();
        writer.write(this.toString(sb, 0, JSON.INCR));
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        return this.toString(sb, 0, 0);
    }

    @Override
    public String toString(StringBuffer sb, int indent, int incr) {
        boolean newObj = true;
        sb.append("{");
        indent += incr;
        TreeSet keyTree = new TreeSet();
        keyTree.addAll(this.keySet());
        Iterator it = keyTree.iterator();
        while (it.hasNext()) {
            Object obj;
            if (newObj) {
                newObj = false;
            } else {
                sb.append(",");
            }
            if (incr > 0) {
                sb.append(System.lineSeparator());
            }
            Object key = it.next();
            for (int i = 0; i < indent; i += incr) {
                sb.append(JSON.BLANKS);
            }
            sb.append("\"" + key + "\":");
            if (incr > 0) {
                sb.append(" ");
            }
            if (!JSON.isValidObject(obj = this.get(key))) continue;
            if (obj instanceof String) {
                sb.append("\"" + JSON.cleanUpString(obj) + "\"");
                continue;
            }
            if (obj instanceof JSONArtifact) {
                sb.append(((JSONArtifact)obj).toString(new StringBuffer(), indent, incr));
                continue;
            }
            sb.append(obj);
        }
        if (incr > 0) {
            sb.append(System.lineSeparator());
        }
        indent -= incr;
        for (int i = 0; i < indent; i += incr) {
            sb.append(JSON.BLANKS);
        }
        sb.append("}");
        return sb.toString();
    }
}

