/*
 * Decompiled with CFR 0.152.
 */
package com.api.json;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class JSONStreamTokenizer {
    private static final int _IS_ORDINARY = 0;
    private static final int _IS_NUMERIC = 1;
    private static final int _IS_QUOTE = 2;
    private static final int _IS_WHITESPACE = 4;
    private static final int _IS_WORD = 8;
    private static final int BSH = 92;
    private static final int BSP = 8;
    private static final int CRT = 13;
    private static final int DPT = 46;
    private static final int DQTE = 34;
    private static final int EOF = -1;
    private static final int FFD = 12;
    private static final int HYP = 45;
    private static final int NLN = 10;
    private static final int SPC = 32;
    private static final int SQTE = 39;
    private static final int TAB = 9;
    public static final int TT_EOF = -1;
    public static final int TT_CR = 13;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    private static final int TT_UNKNOWN = -4;
    public static final int TT_WORD = -3;
    boolean _atEOL = false;
    boolean _eolSignificant = false;
    boolean _isPushedBack = false;
    boolean _lowerCaseMode = false;
    int _nextChar = -1;
    PushbackReader _reader = null;
    StringBuilder _currentValue = new StringBuilder();
    int[] _charTable = new int[65536];
    public double nval = 0.0;
    public String sval = null;
    public int ttype = -4;
    public static int LN_CNTR = 0;
    public static int LN_OFFSET = 1;

    public JSONStreamTokenizer(Reader r) {
        this.resetSyntax();
        this.whitespaceChars(0, 32);
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.parseNumbers();
        this.quoteChar(39);
        this.quoteChar(34);
        this._reader = new PushbackReader(r, 2);
    }

    private boolean checkEOF() {
        if (this._nextChar == -1) {
            this.ttype = -1;
            return true;
        }
        return false;
    }

    private boolean checkForNumber(Integer[] location) throws IOException {
        if ((this._charTable[this._nextChar] & 1) != 0) {
            if (this._nextChar == 45) {
                this._nextChar = this.readNextChar();
                location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                if ((this._charTable[this._nextChar] & 1) == 0) {
                    this._reader.unread(this._nextChar);
                    if (location[LN_OFFSET] > 0) {
                        location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] - 1;
                    }
                    this.ttype = 45;
                    return true;
                }
                this._currentValue.append('-');
            }
            int decimalCount = 0;
            while (true) {
                this._currentValue.append((char)this._nextChar);
                this._nextChar = this.readNextChar();
                location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                if (this._nextChar == -1) {
                    this._reader.unread(this._nextChar);
                    if (location[LN_OFFSET] > 0) {
                        location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] - 1;
                    }
                    try {
                        this.nval = Double.valueOf(this._currentValue.toString());
                        this._currentValue.setLength(0);
                        this.ttype = -2;
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        break;
                    }
                }
                if ((this._charTable[this._nextChar] & 1) == 0 && this._nextChar != 45) {
                    this._reader.unread(this._nextChar);
                    if (location[LN_OFFSET] > 0) {
                        location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] - 1;
                    }
                    try {
                        this.nval = Double.valueOf(this._currentValue.toString());
                        this._currentValue.setLength(0);
                        this.ttype = -2;
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                if (this._nextChar == 46) {
                    ++decimalCount;
                }
                if (decimalCount > 1) {
                    this._reader.unread(this._nextChar);
                    if (location[LN_OFFSET] <= 0) break;
                    location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] - 1;
                    break;
                }
                this._currentValue.append((char)this._nextChar);
            }
        }
        return false;
    }

    private boolean checkForQuotedWord(Integer[] location) throws IOException {
        if ((this._charTable[this._nextChar] & 2) != 0) {
            this.ttype = this._nextChar;
            int _lookAhead = this.readNextChar();
            location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
            while (_lookAhead != this.ttype && _lookAhead != 10 && _lookAhead != 13 && _lookAhead != -1) {
                if (_lookAhead == 92) {
                    this._nextChar = this.readNextChar();
                    location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                    switch (this._nextChar) {
                        case 116: {
                            this._nextChar = 9;
                            break;
                        }
                        case 110: {
                            this._nextChar = 10;
                            break;
                        }
                        case 114: {
                            this._nextChar = 13;
                            break;
                        }
                        case 102: {
                            this._nextChar = 12;
                            break;
                        }
                        case 98: {
                            this._nextChar = 8;
                            break;
                        }
                        case 92: {
                            this._nextChar = 92;
                            break;
                        }
                        case 34: {
                            this._nextChar = 34;
                            break;
                        }
                        case 39: {
                            this._nextChar = 39;
                            break;
                        }
                        case 117: {
                            int d4 = 0;
                            int d1 = this.readNextChar();
                            location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                            if (!this.isHexChar(d1)) break;
                            int d2 = this.readNextChar();
                            location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                            if (!this.isHexChar(d2)) break;
                            int d3 = this.readNextChar();
                            location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                            if (!this.isHexChar(d3)) break;
                            d4 = this.readNextChar();
                            location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                            if (!this.isHexChar(d4)) break;
                            char[] cBuf = new char[]{(char)d1, (char)d2, (char)d3, (char)d4};
                            String test = new String(cBuf);
                            if (test.equalsIgnoreCase("000a")) {
                                this._nextChar = 10;
                                break;
                            }
                            this._nextChar = (char)Integer.parseInt(test, 16);
                            break;
                        }
                    }
                    _lookAhead = this.readNextChar();
                    location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                } else {
                    this._nextChar = _lookAhead;
                    _lookAhead = this.readNextChar();
                    location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                }
                this._currentValue.append((char)this._nextChar);
            }
            if (_lookAhead != this.ttype) {
                this._reader.unread(_lookAhead);
                if (location[LN_OFFSET] > 0) {
                    location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] - 1;
                }
            }
            this.sval = this._currentValue.toString();
            if (this._lowerCaseMode) {
                this.sval = this.sval.toLowerCase();
            }
            return true;
        }
        return false;
    }

    private boolean checkForWord(Integer[] location) throws IOException {
        if ((this._charTable[this._nextChar] & 8) != 0) {
            while ((this._charTable[this._nextChar] & 9) != 0) {
                this._currentValue.append((char)this._nextChar);
                this._nextChar = this.readNextChar();
                location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
                if (this._nextChar != -1) continue;
                this._reader.unread(this._nextChar);
                if (location[LN_OFFSET] > 0) {
                    location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] - 1;
                }
                this.sval = this._currentValue.toString();
                this._currentValue.setLength(0);
                this.ttype = -3;
                return true;
            }
            this._reader.unread(this._nextChar);
            if (location[LN_OFFSET] > 0) {
                location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] - 1;
            }
            this.sval = this._currentValue.toString();
            this._currentValue.setLength(0);
            if (this._lowerCaseMode) {
                this.sval = this.sval.toLowerCase();
            }
            this.ttype = -3;
            return true;
        }
        return false;
    }

    public void eolIsSignificant(boolean flag) {
        this._eolSignificant = flag;
    }

    boolean handleEndOfLine(Integer[] location) throws IOException {
        if (this._nextChar == 13) {
            this._nextChar = this.readNextChar();
            location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
            if (this._nextChar != 10) {
                this._reader.unread(this._nextChar);
                if (location[LN_OFFSET] > 0) {
                    location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] - 1;
                }
            } else {
                location[JSONStreamTokenizer.LN_CNTR] = location[LN_CNTR] + 1;
                location[JSONStreamTokenizer.LN_OFFSET] = 0;
            }
            if (this._eolSignificant) {
                this.ttype = 10;
                return true;
            }
        } else if (this._nextChar == 10) {
            location[JSONStreamTokenizer.LN_CNTR] = location[LN_CNTR] + 1;
            location[JSONStreamTokenizer.LN_OFFSET] = 0;
            if (this._eolSignificant) {
                this.ttype = 10;
                return true;
            }
            this._nextChar = this.readNextChar();
            location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
            if (this._nextChar == -1) {
                this.ttype = -1;
                return true;
            }
        }
        return false;
    }

    boolean isHexChar(int test) {
        return 48 <= test && test <= 57 || 65 <= test && test <= 70 || 97 <= test && test <= 102;
    }

    public int nextToken(Integer[] location) throws IOException {
        if (this._isPushedBack) {
            this._isPushedBack = false;
            return this.ttype;
        }
        this._currentValue.setLength(0);
        this.sval = null;
        this._nextChar = this.readNextChar();
        location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
        this.ttype = this._nextChar;
        if (this.checkEOF()) {
            return this.ttype;
        }
        if (this.skipNewLines(location)) {
            location[JSONStreamTokenizer.LN_CNTR] = location[LN_CNTR] + 1;
            location[JSONStreamTokenizer.LN_OFFSET] = 0;
            if (this.ttype == 32) {
                return this.ttype;
            }
        }
        if (this.skipWhitespace(location)) {
            return this.ttype;
        }
        if (this.checkForNumber(location)) {
            return this.ttype;
        }
        if (this.checkForWord(location)) {
            return this.ttype;
        }
        if (this.checkForQuotedWord(location)) {
            return this.ttype;
        }
        return this.ttype;
    }

    public void ordinaryChar(int ch) {
        this._charTable[ch] = 0;
    }

    public void ordinaryChars(int low, int hi) {
        for (int i = low; i <= hi; ++i) {
            this._charTable[i] = 0;
        }
    }

    public void parseNumbers() {
        int i = 48;
        while (i < 58) {
            int n = i++;
            this._charTable[n] = this._charTable[n] | 1;
        }
        this._charTable[45] = this._charTable[45] | 1;
        this._charTable[46] = this._charTable[46] | 1;
    }

    public void pushBack() throws IOException {
        if (this.ttype != -4) {
            this._isPushedBack = true;
        }
    }

    public void quoteChar(int ch) {
        this._charTable[ch] = 2;
    }

    private int readNextChar() throws IOException {
        if (this._reader == null) {
            throw new IllegalStateException();
        }
        return this._reader.read();
    }

    public void resetSyntax() {
        for (int i = 0; i < this._charTable.length; ++i) {
            this._charTable[i] = i > 255 ? 8 : 0;
        }
    }

    private boolean skipNewLines(Integer[] location) throws IOException {
        if (this._nextChar == 10) {
            this._nextChar = this.readNextChar();
            location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
            if (this._nextChar == -1) {
                this.ttype = -1;
                return true;
            }
            this.ttype = this._nextChar;
            return true;
        }
        return false;
    }

    private boolean skipWhitespace(Integer[] location) throws IOException {
        while ((this._charTable[this._nextChar] & 4) != 0) {
            if (this.handleEndOfLine(location)) {
                return true;
            }
            this._nextChar = this.readNextChar();
            location[JSONStreamTokenizer.LN_OFFSET] = location[LN_OFFSET] + 1;
        }
        return false;
    }

    public String toString() {
        Object value = "";
        switch (this.ttype) {
            case -3: {
                value = this.sval;
                value = "WORD value:" + (String)value;
                break;
            }
            case -1: {
                value = "EOF";
                break;
            }
            case 10: {
                value = "EOL";
                break;
            }
            case -2: {
                value = Double.toString(this.nval);
                value = "NUMBER: value:" + (String)value;
                break;
            }
            case -4: {
                value = "unknown";
                break;
            }
            default: {
                value = (char)this.ttype + "=0x" + Integer.toHexString(this.ttype);
            }
        }
        return "Token[" + (String)value + "]";
    }

    public void whitespaceChars(int low, int hi) {
        for (int i = low; i <= hi; ++i) {
            this._charTable[i] = 4;
        }
    }

    public void wordChars(int low, int hi) {
        int i = low;
        while (i <= hi) {
            int n = i++;
            this._charTable[n] = this._charTable[n] | 8;
        }
    }
}

