/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class EhCacheUtils {
    public static Object get(String cacheName, Object key) {
        CacheManager cacheManager = CacheManager.getInstance();
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        return EhCacheUtils.get((Ehcache)cache, key);
    }

    public static Object get(Ehcache cache, Object key) {
        Element element = cache.get(key);
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public static void set(String cacheName, Object key, Object value) {
        CacheManager cacheManager = CacheManager.getInstance();
        Ehcache cache = cacheManager.addCacheIfAbsent(cacheName);
        EhCacheUtils.set(cache, key, value);
    }

    public static void set(Ehcache cache, Object key, Object value) {
        cache.put(new Element(key, value));
    }

    public static Object setIfAbsent(String cacheName, Object key, Object value) {
        CacheManager cacheManager = CacheManager.getInstance();
        Ehcache cache = cacheManager.addCacheIfAbsent(cacheName);
        return EhCacheUtils.setIfAbsent(cache, key, value);
    }

    public static Object setIfAbsent(Ehcache cache, Object key, Object value) {
        Element element = cache.putIfAbsent(new Element(key, value));
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public static boolean remove(String cacheName, Object key) {
        CacheManager cacheManager = CacheManager.getInstance();
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            return false;
        }
        return EhCacheUtils.remove((Ehcache)cache, key);
    }

    public static boolean remove(Ehcache cache, Object key) {
        return cache.remove(key);
    }

    public static void removeAll(String cacheName) {
        CacheManager cacheManager = CacheManager.getInstance();
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            return;
        }
        EhCacheUtils.removeAll((Ehcache)cache);
    }

    public static void removeAll(Ehcache cache) {
        cache.removeAll();
    }

    public static Object update(String cacheName, Object key, Object value) {
        CacheManager cacheManager = CacheManager.getInstance();
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        return EhCacheUtils.update((Ehcache)cache, key, value);
    }

    public static Object update(Ehcache cache, Object key, Object value) {
        Element element = cache.replace(new Element(key, value));
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }
}

