/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtils {
    private static final String PUBLIC = ".public.pem";
    private static final String PRIVATE = ".private.pem";
    private static String ENCRYPTKEY = ".private.pem";
    private static String DECRYPTKEY = ".private.pem";
    private static final String ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static Map<String, Key> keyCache = new ConcurrentHashMap<String, Key>();
    private static Map<String, Cipher> cipherCache = new ConcurrentHashMap<String, Cipher>();
    private String client;
    private Cipher encryptCipher;
    private Cipher decryptCipher;

    private PrivateKey getPrivateKey(String privateKeyStr) throws Exception {
        byte[] buffer = Base64.getDecoder().decode(privateKeyStr);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private static PublicKey getPublicKey(String publicKeyStr) throws Exception {
        byte[] buffer = Base64.getDecoder().decode(publicKeyStr);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
        return keyFactory.generatePublic(keySpec);
    }

    /*
     * Exception decompiling
     */
    private String getKeyString(String keyName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Key getKey(String client, String type) throws Exception {
        String keyName = client + type;
        Key key = keyCache.get(keyName);
        if (key != null) return key;
        Class<RSAUtils> clazz = RSAUtils.class;
        synchronized (RSAUtils.class) {
            key = keyCache.get(keyName);
            if (key != null) return key;
            String keyString = this.getKeyString(keyName);
            key = type.equals(PRIVATE) ? this.getPrivateKey(keyString) : RSAUtils.getPublicKey(keyString);
            keyCache.put(keyName, key);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return key;
        }
    }

    public RSAUtils(String client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void destroy() {
        String cipherName;
        Class<RSAUtils> clazz;
        if (this.encryptCipher != null) {
            clazz = RSAUtils.class;
            // MONITORENTER : com.github.woshikid.utils.RSAUtils.class
            cipherName = this.client + ".encryptCipher";
            cipherCache.put(cipherName, this.encryptCipher);
            this.encryptCipher = null;
            // MONITOREXIT : clazz
        }
        if (this.decryptCipher == null) return;
        clazz = RSAUtils.class;
        // MONITORENTER : com.github.woshikid.utils.RSAUtils.class
        cipherName = this.client + ".decryptCipher";
        cipherCache.put(cipherName, this.decryptCipher);
        this.decryptCipher = null;
        // MONITOREXIT : clazz
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public byte[] encryptData(byte[] data) throws Exception {
        if (data == null) {
            return null;
        }
        if (this.encryptCipher == null) {
            Class<RSAUtils> clazz = RSAUtils.class;
            // MONITORENTER : com.github.woshikid.utils.RSAUtils.class
            String cipherName = this.client + ".encryptCipher";
            this.encryptCipher = cipherCache.get(cipherName);
            cipherCache.remove(cipherName);
            // MONITOREXIT : clazz
            if (this.encryptCipher == null) {
                Key key = this.getKey(this.client, ENCRYPTKEY);
                this.encryptCipher = Cipher.getInstance(ALGORITHM, (Provider)new BouncyCastleProvider());
                this.encryptCipher.init(1, key);
            }
        }
        int blockSize = this.encryptCipher.getBlockSize();
        int outputSize = this.encryptCipher.getOutputSize(0);
        if (blockSize == 0) {
            blockSize = 117;
            outputSize = 128;
        }
        int pieces = (data.length - 1) / blockSize + 1;
        int rest = data.length % blockSize;
        if (rest == 0 && data.length != 0) {
            rest = blockSize;
        }
        byte[] result = new byte[pieces * outputSize];
        int p = 0;
        while (p < pieces) {
            int length = p == pieces - 1 ? rest : blockSize;
            this.encryptCipher.doFinal(data, p * blockSize, length, result, p * outputSize);
            ++p;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public byte[] decryptData(byte[] data) throws Exception {
        int pieces;
        int blockSize;
        if (data == null) {
            return null;
        }
        if (this.decryptCipher == null) {
            Class<RSAUtils> clazz = RSAUtils.class;
            // MONITORENTER : com.github.woshikid.utils.RSAUtils.class
            String cipherName = this.client + ".decryptCipher";
            this.decryptCipher = cipherCache.get(cipherName);
            cipherCache.remove(cipherName);
            // MONITOREXIT : clazz
            if (this.decryptCipher == null) {
                Key key = this.getKey(this.client, DECRYPTKEY);
                this.decryptCipher = Cipher.getInstance(ALGORITHM, (Provider)new BouncyCastleProvider());
                this.decryptCipher.init(2, key);
            }
        }
        if ((blockSize = this.decryptCipher.getBlockSize()) == 0) {
            blockSize = 128;
        }
        if ((pieces = data.length / blockSize) == 0) {
            throw new Exception("encrypted data is too short");
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int p = 0;
        while (p < pieces) {
            result.write(this.decryptCipher.doFinal(data, p * blockSize, blockSize));
            ++p;
        }
        return result.toByteArray();
    }

    public String encryptString(String param) throws Exception {
        if (param == null) {
            return null;
        }
        byte[] encryptedByte = this.encryptData(param.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encryptedByte);
    }

    public String decryptString(String param) throws Exception {
        if (param == null) {
            return null;
        }
        byte[] decryptedByte = this.decryptData(Base64.getDecoder().decode(param));
        return new String(decryptedByte, StandardCharsets.UTF_8);
    }

    private <T> T opearteObject(T object, boolean encrypt, boolean withSuperClass) throws Exception {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            if (encrypt) {
                return (T)this.encryptString((String)object);
            }
            return (T)this.decryptString((String)object);
        }
        Class<?> clazz = object.getClass();
        Field[] allFields = clazz.getDeclaredFields();
        while (withSuperClass && (clazz = clazz.getSuperclass()) != null) {
            Field[] newFields = clazz.getDeclaredFields();
            if (newFields.length == 0) continue;
            Field[] fields = allFields;
            allFields = new Field[fields.length + newFields.length];
            System.arraycopy(fields, 0, allFields, 0, fields.length);
            System.arraycopy(newFields, 0, allFields, fields.length, newFields.length);
        }
        for (Field field : allFields) {
            Object value;
            if (field.getType().equals(String.class)) {
                field.setAccessible(true);
                value = (String[])field.get(object);
                value = encrypt ? this.encryptString((String)value) : this.decryptString((String)value);
                field.set(object, value);
                continue;
            }
            if (!field.getType().equals(String[].class)) continue;
            field.setAccessible(true);
            value = (String[])field.get(object);
            for (int i = 0; i < ((String[])value).length; ++i) {
                value[i] = encrypt ? this.encryptString(value[i]) : this.decryptString(value[i]);
            }
        }
        return object;
    }

    public <T> T encryptObject(T object) throws Exception {
        return this.opearteObject(object, true, false);
    }

    public <T> T decryptObject(T object) throws Exception {
        return this.opearteObject(object, false, false);
    }

    public <T> T encryptObjectWithSuperClass(T object) throws Exception {
        return this.opearteObject(object, true, true);
    }

    public <T> T decryptObjectWithSuperClass(T object) throws Exception {
        return this.opearteObject(object, false, true);
    }

    public static <T> T encrypt(T object, String client) throws Exception {
        RSAUtils rsaUtil = new RSAUtils(client);
        T t = rsaUtil.encryptObject(object);
        rsaUtil.destroy();
        return t;
    }

    public static <T> T decrypt(T object, String client) throws Exception {
        RSAUtils rsaUtil = new RSAUtils(client);
        T t = rsaUtil.decryptObject(object);
        rsaUtil.destroy();
        return t;
    }

    public static <T> T deepEncrypt(T object, String client) throws Exception {
        RSAUtils rsaUtil = new RSAUtils(client);
        T t = rsaUtil.encryptObjectWithSuperClass(object);
        rsaUtil.destroy();
        return t;
    }

    public static <T> T deepDecrypt(T object, String client) throws Exception {
        RSAUtils rsaUtil = new RSAUtils(client);
        T t = rsaUtil.decryptObjectWithSuperClass(object);
        rsaUtil.destroy();
        return t;
    }
}

