/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import java.util.Map;

public class HtmlUtils {
    public static String js(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value).replace("\\", "\\\\").replace("'", "\\'").replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
    }

    public static String value(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value).replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&#39;").replace(" ", "&#32;").replace("\r", "").replace("\n", "");
    }

    public static String content(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value).replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&#39;").replace(" ", "&#32;");
    }

    public static String td(Object value) {
        if (value == null) {
            return "\u3000";
        }
        String td = String.valueOf(value).trim();
        if (td.length() == 0) {
            return "\u3000";
        }
        return HtmlUtils.content(td);
    }

    public static String buildOptions(Map<String, Object> map, String defaultKey) {
        if (map == null) {
            return "";
        }
        StringBuffer options = new StringBuffer();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            String text = value == null ? "" : String.valueOf(value);
            boolean selected = String.valueOf(key).equals(defaultKey);
            options.append("<option").append(selected ? " selected" : "");
            options.append(" value='").append(HtmlUtils.value(key)).append("'>");
            options.append(HtmlUtils.value(text)).append("</option>\n");
        }
        return options.toString();
    }
}

