/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final ThreadLocal<Boolean> followRedirects = new ThreadLocal();
    private static final ThreadLocal<Integer> httpTimeout = new ThreadLocal();

    public static void setFollowRedirects(boolean follow) {
        followRedirects.set(follow);
    }

    public static void setTimeout(int timeout) {
        httpTimeout.set(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Response request(String url, Map<String, String> header, byte[] data) throws IOException {
        Integer timeout;
        long threadId = Thread.currentThread().getId();
        logger.info("[{}] request url={}", (Object)threadId, (Object)url);
        HttpURLConnection http = (HttpURLConnection)new URL(url).openConnection();
        http.setUseCaches(false);
        http.setDoInput(true);
        http.setDoOutput(data != null);
        http.setRequestProperty("Connection", "Close");
        Boolean follow = followRedirects.get();
        if (follow != null) {
            followRedirects.remove();
            http.setInstanceFollowRedirects(follow);
        }
        if ((timeout = httpTimeout.get()) == null) {
            timeout = 60000;
        } else {
            httpTimeout.remove();
        }
        http.setConnectTimeout(timeout);
        http.setReadTimeout(timeout);
        if (header != null) {
            for (String string : header.keySet()) {
                String value = header.get(string);
                logger.info("[{}] header:{}={}", new Object[]{threadId, string, value});
                http.setRequestProperty(string, value);
            }
        }
        http.connect();
        try {
            String charset;
            Matcher matcher;
            void var9_14;
            if (data != null) {
                Throwable throwable = null;
                try (OutputStream out = http.getOutputStream();){
                    out.write(data);
                }
                catch (Throwable value) {
                    Throwable throwable2 = value;
                    throw value;
                }
            }
            ByteArrayOutputStream cache = new ByteArrayOutputStream();
            try {
                InputStream inputStream = http.getInputStream();
            }
            catch (IOException e) {
                InputStream inputStream = http.getErrorStream();
            }
            if (var9_14 != null) {
                void var9_16;
                try {
                    int length;
                    String encode = http.getContentEncoding();
                    if (encode != null && encode.trim().equalsIgnoreCase("gzip")) {
                        GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)var9_14);
                    }
                    byte[] buffer = new byte[8192];
                    while ((length = var9_16.read(buffer)) != -1) {
                        cache.write(buffer, 0, length);
                    }
                }
                catch (Throwable throwable) {
                    var9_14.close();
                    throw throwable;
                }
                var9_16.close();
            }
            Response response = new Response();
            response.data = cache.toByteArray();
            response.header = http.getHeaderFields();
            response.code = http.getResponseCode();
            String contentType = http.getContentType();
            if (contentType != null && (matcher = Pattern.compile("(?i)\\bcharset\\s*=\\s*([^\\s;]+)").matcher(contentType)).find() && Charset.isSupported(charset = matcher.group(1))) {
                response.charset = Charset.forName(charset);
            }
            if (response.charset == null) {
                String charset2;
                int length = response.data.length;
                if (length > 1024) {
                    length = 1024;
                }
                String head = new String(response.data, 0, length);
                Matcher matcher2 = Pattern.compile("(?is)<meta\\s[^>]*\\bcharset\\s*=\\s*['\"]?\\s*([^\\s'\"/>]+)[^>]*>").matcher(head);
                if (matcher2.find() && Charset.isSupported(charset2 = matcher2.group(1))) {
                    response.charset = Charset.forName(charset2);
                }
            }
            logger.info("[{}] response.code={}", (Object)threadId, (Object)response.code);
            logger.info("[{}] response.data.length={}", (Object)threadId, (Object)response.data.length);
            Response response2 = response;
            return response2;
        }
        finally {
            http.disconnect();
        }
    }

    public static String encodeUtf8(Object input) {
        try {
            return URLEncoder.encode(String.valueOf(input), "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String buildGetParameter(Map<String, Object> map) {
        if (map == null) {
            return "";
        }
        StringBuffer parameter = new StringBuffer();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            parameter.append("&").append(HttpUtils.encodeUtf8(key));
            parameter.append("=").append(HttpUtils.encodeUtf8(value));
        }
        if (parameter.length() > 0) {
            parameter.deleteCharAt(0);
        }
        return parameter.toString();
    }

    public static String buildPostParameter(Map<String, Object> map) {
        if (map == null) {
            return "";
        }
        StringBuffer parameter = new StringBuffer();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            parameter.append("&").append(key);
            parameter.append("=").append(value);
        }
        if (parameter.length() > 0) {
            parameter.deleteCharAt(0);
        }
        return parameter.toString();
    }

    public static class Response {
        public int code;
        public Map<String, List<String>> header;
        public Charset charset;
        public byte[] data;

        public String getText() throws IOException {
            if (this.code != 200) {
                throw new IOException("HTTP Status Code:" + this.code);
            }
            return this.getTextIgnoreError();
        }

        public String getTextIgnoreError() {
            if (this.charset != null) {
                return new String(this.data, this.charset);
            }
            return new String(this.data, StandardCharsets.UTF_8);
        }
    }
}

