/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import com.github.woshikid.utils.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.JedisClusterCRC16;

public class RedisUtils {
    private static JedisCluster jedisCluster = null;
    private static JedisSentinelPool jedisSentinelPool = null;
    private static JedisPool jedisPool = null;

    public static int getSlot(Object key) {
        return JedisClusterCRC16.getSlot((byte[])RedisUtils.toBytes(key));
    }

    public static JedisCluster getJedisCluster() {
        if (jedisCluster != null) {
            return jedisCluster;
        }
        throw new RuntimeException("jedis cluster not ready");
    }

    public static Jedis getJedis() {
        if (jedisSentinelPool != null) {
            return jedisSentinelPool.getResource();
        }
        if (jedisPool != null) {
            return jedisPool.getResource();
        }
        throw new RuntimeException("jedis not ready");
    }

    private static byte[] toBytes(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return ((String)object).getBytes(StandardCharsets.UTF_8);
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Boolean) {
            return object.toString().getBytes(StandardCharsets.UTF_8);
        }
        if (object instanceof Number) {
            return object.toString().getBytes(StandardCharsets.UTF_8);
        }
        return ObjectUtils.serialize(object);
    }

    private static byte[][] toBytes(Object ... objects) {
        if (objects == null) {
            return null;
        }
        byte[][] bytes = new byte[objects.length][];
        for (int i = 0; i < objects.length; ++i) {
            bytes[i] = RedisUtils.toBytes(objects[i]);
        }
        return bytes;
    }

    private static Map<byte[], byte[]> toBytes(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        HashMap<byte[], byte[]> byteMap = new HashMap<byte[], byte[]>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            byteMap.put(RedisUtils.toBytes(entry.getKey()), RedisUtils.toBytes(entry.getValue()));
        }
        return byteMap;
    }

    private static Map<byte[], Double> toBytesZ(Map<?, Double> map) {
        if (map == null) {
            return null;
        }
        HashMap<byte[], Double> byteMap = new HashMap<byte[], Double>(map.size());
        for (Map.Entry<?, Double> entry : map.entrySet()) {
            byteMap.put(RedisUtils.toBytes(entry.getKey()), entry.getValue());
        }
        return byteMap;
    }

    private static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static List<String> toString(List<byte[]> byteList) {
        if (byteList == null) {
            return null;
        }
        return byteList.parallelStream().map(bytes -> RedisUtils.toString(bytes)).collect(Collectors.toList());
    }

    private static Set<String> toString(Set<byte[]> byteSet) {
        if (byteSet == null) {
            return null;
        }
        return byteSet.parallelStream().map(bytes -> RedisUtils.toString(bytes)).collect(Collectors.toSet());
    }

    private static Map.Entry<String, String> toString(Map.Entry<byte[], byte[]> byteEntry) {
        if (byteEntry == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>(RedisUtils.toString(byteEntry.getKey()), RedisUtils.toString(byteEntry.getValue()));
    }

    private static Map<String, String> toString(Map<byte[], byte[]> byteMap) {
        if (byteMap == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(byteMap.size());
        for (Map.Entry<byte[], byte[]> entry : byteMap.entrySet()) {
            map.put(RedisUtils.toString(entry.getKey()), RedisUtils.toString(entry.getValue()));
        }
        return map;
    }

    private static ScanResult<String> toString(ScanResult<byte[]> byteResult) {
        if (byteResult == null) {
            return null;
        }
        String cursor = RedisUtils.toString(byteResult.getCursorAsBytes());
        List<String> results = RedisUtils.toString(byteResult.getResult());
        return new ScanResult(cursor, results);
    }

    private static ScanResult<Map.Entry<String, String>> toStringH(ScanResult<Map.Entry<byte[], byte[]>> byteResult) {
        if (byteResult == null) {
            return null;
        }
        String cursor = RedisUtils.toString(byteResult.getCursorAsBytes());
        List byteList = byteResult.getResult();
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(byteList.size());
        for (Map.Entry bytes : byteList) {
            list.add(RedisUtils.toString(bytes));
        }
        return new ScanResult(cursor, list);
    }

    private static BinaryClient.LIST_POSITION toListPosition(String where) {
        if ("BEFORE".equalsIgnoreCase(where)) {
            return BinaryClient.LIST_POSITION.BEFORE;
        }
        if ("AFTER".equalsIgnoreCase(where)) {
            return BinaryClient.LIST_POSITION.AFTER;
        }
        throw new IllegalArgumentException("unknow position:" + where);
    }

    private static ScanParams toScanParams(String match, Integer count) {
        ScanParams params = new ScanParams();
        if (match != null) {
            params.match(match);
        }
        if (count != null) {
            params.count(count);
        }
        return params;
    }

    private static SortingParams toSortingParams(String by, String ascdesc, String alpha, Integer offset, Integer count, String[] get) {
        SortingParams params = new SortingParams();
        if (by != null) {
            params.by(by);
        }
        if ("asc".equalsIgnoreCase(ascdesc)) {
            params.asc();
        }
        if ("desc".equalsIgnoreCase(ascdesc)) {
            params.desc();
        }
        if ("alpha".equalsIgnoreCase(alpha)) {
            params.alpha();
        }
        if (offset != null && count != null) {
            params.limit(offset.intValue(), count.intValue());
        }
        if (get != null) {
            params.get(get);
        }
        return params;
    }

    private static BitPosParams toBitPosParams(long start, Long end) {
        if (end == null) {
            return new BitPosParams(start);
        }
        return new BitPosParams(start, end.longValue());
    }

    private static BitOP toBitOP(String bitop) {
        if ("AND".equalsIgnoreCase(bitop)) {
            return BitOP.AND;
        }
        if ("OR".equalsIgnoreCase(bitop)) {
            return BitOP.OR;
        }
        if ("XOR".equalsIgnoreCase(bitop)) {
            return BitOP.XOR;
        }
        if ("NOT".equalsIgnoreCase(bitop)) {
            return BitOP.NOT;
        }
        throw new IllegalArgumentException("unknow bitop:" + bitop);
    }

    private static ZAddParams toZAddParams(String nxxx, String ch) {
        ZAddParams params = ZAddParams.zAddParams();
        if ("nx".equalsIgnoreCase(nxxx)) {
            params.nx();
        }
        if ("xx".equalsIgnoreCase(nxxx)) {
            params.xx();
        }
        if ("ch".equalsIgnoreCase(ch)) {
            params.ch();
        }
        return params;
    }

    private static ZIncrByParams toZIncrByParams(String nxxx) {
        ZIncrByParams params = ZIncrByParams.zIncrByParams();
        if ("nx".equalsIgnoreCase(nxxx)) {
            params.nx();
        }
        if ("xx".equalsIgnoreCase(nxxx)) {
            params.xx();
        }
        return params;
    }

    private static ZParams toZParams(double[] weights, String aggregate) {
        ZParams params = new ZParams();
        if (weights != null) {
            params.weightsByDouble(weights);
        }
        if ("SUM".equalsIgnoreCase(aggregate)) {
            params.aggregate(ZParams.Aggregate.SUM);
        }
        if ("MIN".equalsIgnoreCase(aggregate)) {
            params.aggregate(ZParams.Aggregate.MIN);
        }
        if ("MAX".equalsIgnoreCase(aggregate)) {
            params.aggregate(ZParams.Aggregate.MAX);
        }
        return params;
    }

    public static long ping() {
        try (Jedis jedis = RedisUtils.getJedis();){
            long now = System.nanoTime();
            jedis.ping();
            long l = System.nanoTime() - now;
            return l;
        }
    }

    public static List<String> time() {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.time();
            return list;
        }
    }

    public static long dbSize() {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.dbSize();
            return l;
        }
    }

    public static long lastsave() {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.lastsave();
            return l;
        }
    }

    public static void bgrewriteaof() {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.bgrewriteaof();
        }
    }

    public static void bgsave() {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.bgsave();
        }
    }

    public static boolean del(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.del(RedisUtils.toBytes(key)) == 1L;
            return bl;
        }
    }

    public static long del(Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.del(RedisUtils.toBytes(keys));
            return l;
        }
    }

    public static boolean exists(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.exists(RedisUtils.toBytes(key));
            return bl;
        }
    }

    public static long exists(Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.exists(RedisUtils.toBytes(keys));
            return l;
        }
    }

    public static boolean expire(Object key, int seconds) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.expire(RedisUtils.toBytes(key), seconds) == 1L;
            return bl;
        }
    }

    public static boolean expireAt(Object key, long unixTime) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.expireAt(RedisUtils.toBytes(key), unixTime) == 1L;
            return bl;
        }
    }

    public static boolean pexpire(Object key, long milliseconds) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.pexpire(RedisUtils.toBytes(key), milliseconds) == 1L;
            return bl;
        }
    }

    public static boolean pexpireAt(Object key, long millisecondsTimestamp) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.pexpireAt(RedisUtils.toBytes(key), millisecondsTimestamp) == 1L;
            return bl;
        }
    }

    public static long ttl(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.ttl(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static long pttl(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.pttl(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static boolean persist(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.persist(RedisUtils.toBytes(key)) == 1L;
            return bl;
        }
    }

    public static Long idle(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Long l = jedis.objectIdletime(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static String type(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            String string = jedis.type(RedisUtils.toBytes(key));
            return string;
        }
    }

    public static boolean move(Object key, int dbIndex) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.move(RedisUtils.toBytes(key), dbIndex) == 1L;
            return bl;
        }
    }

    public static void rename(Object oldkey, Object newkey) {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.rename(RedisUtils.toBytes(oldkey), RedisUtils.toBytes(newkey));
        }
    }

    public static boolean renamenx(Object oldkey, Object newkey) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.renamenx(RedisUtils.toBytes(oldkey), RedisUtils.toBytes(newkey)) == 1L;
            return bl;
        }
    }

    public static byte[] dump(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.dump(RedisUtils.toBytes(key));
            return byArray;
        }
    }

    public static void restore(Object key, int ttl, byte[] serializedValue) {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.restore(RedisUtils.toBytes(key), ttl, serializedValue);
        }
    }

    public static byte[] randomKeyBytes() {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.randomBinaryKey();
            return byArray;
        }
    }

    public static String randomKey() {
        return RedisUtils.toString(RedisUtils.randomKeyBytes());
    }

    public static Set<byte[]> keysBytes(String pattern) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.keys(RedisUtils.toBytes((Object)pattern));
            return set;
        }
    }

    public static Set<String> keys(String pattern) {
        return RedisUtils.toString(RedisUtils.keysBytes(pattern));
    }

    public static ScanResult<byte[]> scanBytes(String cursor) {
        try (Jedis jedis = RedisUtils.getJedis();){
            ScanResult scanResult = jedis.scan(RedisUtils.toBytes((Object)cursor));
            return scanResult;
        }
    }

    public static ScanResult<String> scan(String cursor) {
        return RedisUtils.toString(RedisUtils.scanBytes(cursor));
    }

    public static ScanResult<byte[]> scanBytes(String cursor, String match, Integer count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            ScanResult scanResult = jedis.scan(RedisUtils.toBytes((Object)cursor), RedisUtils.toScanParams(match, count));
            return scanResult;
        }
    }

    public static ScanResult<String> scan(String cursor, String match, Integer count) {
        return RedisUtils.toString(RedisUtils.scanBytes(cursor, match, count));
    }

    public static List<byte[]> sortBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.sort(RedisUtils.toBytes(key));
            return list;
        }
    }

    public static List<String> sort(Object key) {
        return RedisUtils.toString(RedisUtils.sortBytes(key));
    }

    public static long sort(Object key, Object dstkey) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.sort(RedisUtils.toBytes(key), RedisUtils.toBytes(dstkey));
            return l;
        }
    }

    public static List<byte[]> sortBytes(Object key, String by, String ascdesc, String alpha, Integer offset, Integer count, String ... get) {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.sort(RedisUtils.toBytes(key), RedisUtils.toSortingParams(by, ascdesc, alpha, offset, count, get));
            return list;
        }
    }

    public static List<String> sort(Object key, String by, String ascdesc, String alpha, Integer offset, Integer count, String ... get) {
        return RedisUtils.toString(RedisUtils.sortBytes(key, by, ascdesc, alpha, offset, count, get));
    }

    public static long sort(Object key, Object dstkey, String by, String ascdesc, String alpha, Integer offset, Integer count, String ... get) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.sort(RedisUtils.toBytes(key), RedisUtils.toSortingParams(by, ascdesc, alpha, offset, count, get), RedisUtils.toBytes(dstkey));
            return l;
        }
    }

    public static boolean set(Object key, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.set(RedisUtils.toBytes(key), RedisUtils.toBytes(value)) != null;
            return bl;
        }
    }

    public static boolean set(Object key, Object value, String nxxx) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.set(RedisUtils.toBytes(key), RedisUtils.toBytes(value), RedisUtils.toBytes((Object)nxxx)) != null;
            return bl;
        }
    }

    public static boolean set(Object key, Object value, String nxxx, String expx, long time) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.set(RedisUtils.toBytes(key), RedisUtils.toBytes(value), RedisUtils.toBytes((Object)nxxx), RedisUtils.toBytes((Object)expx), time) != null;
            return bl;
        }
    }

    public static byte[] getBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.get(RedisUtils.toBytes(key));
            return byArray;
        }
    }

    public static String get(Object key) {
        return RedisUtils.toString(RedisUtils.getBytes(key));
    }

    public static void mset(Object ... keysvalues) {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.mset(RedisUtils.toBytes(keysvalues));
        }
    }

    public static boolean msetnx(Object ... keysvalues) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.msetnx(RedisUtils.toBytes(keysvalues)) == 1L;
            return bl;
        }
    }

    public static List<byte[]> mgetBytes(Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.mget(RedisUtils.toBytes(keys));
            return list;
        }
    }

    public static List<String> mget(Object ... keys) {
        return RedisUtils.toString(RedisUtils.mgetBytes(keys));
    }

    public static boolean setnx(Object key, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.setnx(RedisUtils.toBytes(key), RedisUtils.toBytes(value)) == 1L;
            return bl;
        }
    }

    public static void setex(Object key, int seconds, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.setex(RedisUtils.toBytes(key), seconds, RedisUtils.toBytes(value));
        }
    }

    public static void psetex(Object key, long milliseconds, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.psetex(RedisUtils.toBytes(key), milliseconds, RedisUtils.toBytes(value));
        }
    }

    public static byte[] getSetBytes(Object key, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.getSet(RedisUtils.toBytes(key), RedisUtils.toBytes(value));
            return byArray;
        }
    }

    public static String getSet(Object key, Object value) {
        return RedisUtils.toString(RedisUtils.getSetBytes(key, value));
    }

    public static long decrBy(Object key, long integer) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.decrBy(RedisUtils.toBytes(key), integer);
            return l;
        }
    }

    public static long decr(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.decr(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static long incrBy(Object key, long integer) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.incrBy(RedisUtils.toBytes(key), integer);
            return l;
        }
    }

    public static double incrByFloat(Object key, double value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            double d = jedis.incrByFloat(RedisUtils.toBytes(key), value);
            return d;
        }
    }

    public static long incr(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.incr(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static long append(Object key, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.append(RedisUtils.toBytes(key), RedisUtils.toBytes(value));
            return l;
        }
    }

    public static long strlen(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.strlen(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static long setrange(Object key, long offset, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.setrange(RedisUtils.toBytes(key), offset, RedisUtils.toBytes(value));
            return l;
        }
    }

    public static byte[] getrangeBytes(Object key, long startOffset, long endOffset) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.getrange(RedisUtils.toBytes(key), startOffset, endOffset);
            return byArray;
        }
    }

    public static String getrange(Object key, long startOffset, long endOffset) {
        return RedisUtils.toString(RedisUtils.getrangeBytes(key, startOffset, endOffset));
    }

    @Deprecated
    public static byte[] substrBytes(Object key, int start, int end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.substr(RedisUtils.toBytes(key), start, end);
            return byArray;
        }
    }

    @Deprecated
    public static String substr(Object key, int start, int end) {
        return RedisUtils.toString(RedisUtils.substrBytes(key, start, end));
    }

    public static boolean setbit(Object key, long offset, boolean value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.setbit(RedisUtils.toBytes(key), offset, value);
            return bl;
        }
    }

    public static boolean setbit(Object key, long offset, String value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.setbit(RedisUtils.toBytes(key), offset, RedisUtils.toBytes((Object)value));
            return bl;
        }
    }

    public static boolean getbit(Object key, long offset) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.getbit(RedisUtils.toBytes(key), offset);
            return bl;
        }
    }

    public static long bitcount(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.bitcount(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static long bitcount(Object key, long start, long end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.bitcount(RedisUtils.toBytes(key), start, end);
            return l;
        }
    }

    public static long bitop(String bitop, Object destKey, Object ... srcKeys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.bitop(RedisUtils.toBitOP(bitop), RedisUtils.toBytes(destKey), RedisUtils.toBytes(srcKeys));
            return l;
        }
    }

    public static long bitpos(Object key, boolean value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.bitpos(RedisUtils.toBytes(key), value);
            return l;
        }
    }

    public static long bitpos(Object key, boolean value, long start, Long end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.bitpos(RedisUtils.toBytes(key), value, RedisUtils.toBitPosParams(start, end));
            return l;
        }
    }

    public static boolean hset(Object key, Object field, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.hset(RedisUtils.toBytes(key), RedisUtils.toBytes(field), RedisUtils.toBytes(value)) == 1L;
            return bl;
        }
    }

    public static byte[] hgetBytes(Object key, Object field) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.hget(RedisUtils.toBytes(key), RedisUtils.toBytes(field));
            return byArray;
        }
    }

    public static String hget(Object key, Object field) {
        return RedisUtils.toString(RedisUtils.hgetBytes(key, field));
    }

    public static boolean hsetnx(Object key, Object field, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.hsetnx(RedisUtils.toBytes(key), RedisUtils.toBytes(field), RedisUtils.toBytes(value)) == 1L;
            return bl;
        }
    }

    public static void hmset(Object key, Map<?, ?> hash) {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.hmset(RedisUtils.toBytes(key), RedisUtils.toBytes(hash));
        }
    }

    public static List<byte[]> hmgetBytes(Object key, Object ... fields) {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.hmget(RedisUtils.toBytes(key), RedisUtils.toBytes(fields));
            return list;
        }
    }

    public static List<String> hmget(Object key, Object ... fields) {
        return RedisUtils.toString(RedisUtils.hmgetBytes(key, fields));
    }

    public static long hincrBy(Object key, Object field, long value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.hincrBy(RedisUtils.toBytes(key), RedisUtils.toBytes(field), value);
            return l;
        }
    }

    public static double hincrByFloat(Object key, Object field, double value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            double d = jedis.hincrByFloat(RedisUtils.toBytes(key), RedisUtils.toBytes(field), value);
            return d;
        }
    }

    public static boolean hexists(Object key, Object field) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.hexists(RedisUtils.toBytes(key), RedisUtils.toBytes(field));
            return bl;
        }
    }

    public static long hdel(Object key, Object ... fields) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.hdel(RedisUtils.toBytes(key), RedisUtils.toBytes(fields));
            return l;
        }
    }

    public static long hlen(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.hlen(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static Set<byte[]> hkeysBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.hkeys(RedisUtils.toBytes(key));
            return set;
        }
    }

    public static Set<String> hkeys(Object key) {
        return RedisUtils.toString(RedisUtils.hkeysBytes(key));
    }

    public static List<byte[]> hvalsBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.hvals(RedisUtils.toBytes(key));
            return list;
        }
    }

    public static List<String> hvals(Object key) {
        return RedisUtils.toString(RedisUtils.hvalsBytes(key));
    }

    public static Map<byte[], byte[]> hgetAllBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Map map = jedis.hgetAll(RedisUtils.toBytes(key));
            return map;
        }
    }

    public static Map<String, String> hgetAll(Object key) {
        return RedisUtils.toString(RedisUtils.hgetAllBytes(key));
    }

    public static ScanResult<Map.Entry<byte[], byte[]>> hscanBytes(Object key, String cursor) {
        try (Jedis jedis = RedisUtils.getJedis();){
            ScanResult scanResult = jedis.hscan(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)cursor));
            return scanResult;
        }
    }

    public static ScanResult<Map.Entry<String, String>> hscan(Object key, String cursor) {
        return RedisUtils.toStringH(RedisUtils.hscanBytes(key, cursor));
    }

    public static ScanResult<Map.Entry<byte[], byte[]>> hscanBytes(Object key, String cursor, String match, Integer count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            ScanResult scanResult = jedis.hscan(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)cursor), RedisUtils.toScanParams(match, count));
            return scanResult;
        }
    }

    public static ScanResult<Map.Entry<String, String>> hscan(Object key, String cursor, String match, Integer count) {
        return RedisUtils.toStringH(RedisUtils.hscanBytes(key, cursor, match, count));
    }

    public static long rpush(Object key, Object ... values) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.rpush(RedisUtils.toBytes(key), RedisUtils.toBytes(values));
            return l;
        }
    }

    public static long lpush(Object key, Object ... values) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.lpush(RedisUtils.toBytes(key), RedisUtils.toBytes(values));
            return l;
        }
    }

    public static long rpushx(Object key, Object ... values) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.rpushx(RedisUtils.toBytes(key), RedisUtils.toBytes(values));
            return l;
        }
    }

    public static long lpushx(Object key, Object ... values) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.lpushx(RedisUtils.toBytes(key), RedisUtils.toBytes(values));
            return l;
        }
    }

    public static long llen(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.llen(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static List<byte[]> lrangeBytes(Object key, long start, long end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.lrange(RedisUtils.toBytes(key), start, end);
            return list;
        }
    }

    public static List<String> lrange(Object key, long start, long end) {
        return RedisUtils.toString(RedisUtils.lrangeBytes(key, start, end));
    }

    public static void ltrim(Object key, long start, long end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.ltrim(RedisUtils.toBytes(key), start, end);
        }
    }

    public static byte[] lindexBytes(Object key, long index) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.lindex(RedisUtils.toBytes(key), index);
            return byArray;
        }
    }

    public static String lindex(Object key, long index) {
        return RedisUtils.toString(RedisUtils.lindexBytes(key, index));
    }

    public static void lset(Object key, long index, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.lset(RedisUtils.toBytes(key), index, RedisUtils.toBytes(value));
        }
    }

    public static long linsert(Object key, String where, Object pivot, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.linsert(RedisUtils.toBytes(key), RedisUtils.toListPosition(where), RedisUtils.toBytes(pivot), RedisUtils.toBytes(value));
            return l;
        }
    }

    public static long lrem(Object key, long count, Object value) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.lrem(RedisUtils.toBytes(key), count, RedisUtils.toBytes(value));
            return l;
        }
    }

    public static byte[] lpopBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.lpop(RedisUtils.toBytes(key));
            return byArray;
        }
    }

    public static String lpop(Object key) {
        return RedisUtils.toString(RedisUtils.lpopBytes(key));
    }

    public static byte[] rpopBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.rpop(RedisUtils.toBytes(key));
            return byArray;
        }
    }

    public static String rpop(Object key) {
        return RedisUtils.toString(RedisUtils.rpopBytes(key));
    }

    public static byte[] rpoplpushBytes(Object srckey, Object dstkey) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.rpoplpush(RedisUtils.toBytes(srckey), RedisUtils.toBytes(dstkey));
            return byArray;
        }
    }

    public static String rpoplpush(Object srckey, Object dstkey) {
        return RedisUtils.toString(RedisUtils.rpoplpushBytes(srckey, dstkey));
    }

    public static List<byte[]> blpopBytes(int timeout, Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.blpop(timeout, RedisUtils.toBytes(keys));
            return list;
        }
    }

    public static List<String> blpop(int timeout, Object ... keys) {
        return RedisUtils.toString(RedisUtils.blpopBytes(timeout, keys));
    }

    public static List<byte[]> brpopBytes(int timeout, Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.brpop(timeout, RedisUtils.toBytes(keys));
            return list;
        }
    }

    public static List<String> brpop(int timeout, Object ... keys) {
        return RedisUtils.toString(RedisUtils.brpopBytes(timeout, keys));
    }

    public static byte[] brpoplpushBytes(Object source, Object destination, int timeout) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.brpoplpush(RedisUtils.toBytes(source), RedisUtils.toBytes(destination), timeout);
            return byArray;
        }
    }

    public static String brpoplpush(Object source, Object destination, int timeout) {
        return RedisUtils.toString(RedisUtils.brpoplpushBytes(source, destination, timeout));
    }

    public static long sadd(Object key, Object ... members) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.sadd(RedisUtils.toBytes(key), RedisUtils.toBytes(members));
            return l;
        }
    }

    public static boolean smove(Object srckey, Object dstkey, Object member) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.smove(RedisUtils.toBytes(srckey), RedisUtils.toBytes(dstkey), RedisUtils.toBytes(member)) == 1L;
            return bl;
        }
    }

    public static long srem(Object key, Object ... members) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.srem(RedisUtils.toBytes(key), RedisUtils.toBytes(members));
            return l;
        }
    }

    public static byte[] spopBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.spop(RedisUtils.toBytes(key));
            return byArray;
        }
    }

    public static String spop(Object key) {
        return RedisUtils.toString(RedisUtils.spopBytes(key));
    }

    public static Set<byte[]> spopBytes(Object key, long count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.spop(RedisUtils.toBytes(key), count);
            return set;
        }
    }

    public static Set<String> spop(Object key, long count) {
        return RedisUtils.toString(RedisUtils.spopBytes(key, count));
    }

    public static long scard(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.scard(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static Set<byte[]> sdiffBytes(Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.sdiff(RedisUtils.toBytes(keys));
            return set;
        }
    }

    public static Set<String> sdiff(Object ... keys) {
        return RedisUtils.toString(RedisUtils.sdiffBytes(keys));
    }

    public static long sdiffstore(Object dstkey, Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.sdiffstore(RedisUtils.toBytes(dstkey), RedisUtils.toBytes(keys));
            return l;
        }
    }

    public static Set<byte[]> sinterBytes(Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.sinter(RedisUtils.toBytes(keys));
            return set;
        }
    }

    public static Set<String> sinter(Object ... keys) {
        return RedisUtils.toString(RedisUtils.sinterBytes(keys));
    }

    public static long sinterstore(Object dstkey, Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.sinterstore(RedisUtils.toBytes(dstkey), RedisUtils.toBytes(keys));
            return l;
        }
    }

    public static Set<byte[]> sunionBytes(Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.sunion(RedisUtils.toBytes(keys));
            return set;
        }
    }

    public static Set<String> sunion(Object ... keys) {
        return RedisUtils.toString(RedisUtils.sunionBytes(keys));
    }

    public static long sunionstore(Object dstkey, Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.sunionstore(RedisUtils.toBytes(dstkey), RedisUtils.toBytes(keys));
            return l;
        }
    }

    public static boolean sismember(Object key, Object member) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.sismember(RedisUtils.toBytes(key), RedisUtils.toBytes(member));
            return bl;
        }
    }

    public static byte[] srandmemberBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            byte[] byArray = jedis.srandmember(RedisUtils.toBytes(key));
            return byArray;
        }
    }

    public static String srandmember(Object key) {
        return RedisUtils.toString(RedisUtils.srandmemberBytes(key));
    }

    public static List<byte[]> srandmemberBytes(Object key, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            List list = jedis.srandmember(RedisUtils.toBytes(key), count);
            return list;
        }
    }

    public static List<String> srandmember(Object key, int count) {
        return RedisUtils.toString(RedisUtils.srandmemberBytes(key, count));
    }

    public static Set<byte[]> smembersBytes(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.smembers(RedisUtils.toBytes(key));
            return set;
        }
    }

    public static Set<String> smembers(Object key) {
        return RedisUtils.toString(RedisUtils.smembersBytes(key));
    }

    public static ScanResult<byte[]> sscanBytes(Object key, String cursor) {
        try (Jedis jedis = RedisUtils.getJedis();){
            ScanResult scanResult = jedis.sscan(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)cursor));
            return scanResult;
        }
    }

    public static ScanResult<String> sscan(Object key, String cursor) {
        return RedisUtils.toString(RedisUtils.sscanBytes(key, cursor));
    }

    public static ScanResult<byte[]> sscanBytes(Object key, String cursor, String match, Integer count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            ScanResult scanResult = jedis.sscan(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)cursor), RedisUtils.toScanParams(match, count));
            return scanResult;
        }
    }

    public static ScanResult<String> sscan(Object key, String cursor, String match, Integer count) {
        return RedisUtils.toString(RedisUtils.sscanBytes(key, cursor, match, count));
    }

    public static boolean zadd(Object key, double score, Object member) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.zadd(RedisUtils.toBytes(key), score, RedisUtils.toBytes(member)) == 1L;
            return bl;
        }
    }

    public static boolean zadd(Object key, double score, Object member, String nxxx, String ch) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.zadd(RedisUtils.toBytes(key), score, RedisUtils.toBytes(member), RedisUtils.toZAddParams(nxxx, ch)) == 1L;
            return bl;
        }
    }

    public static long zadd(Object key, Map<?, Double> scoreMembers) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zadd(RedisUtils.toBytes(key), RedisUtils.toBytesZ(scoreMembers));
            return l;
        }
    }

    public static long zadd(Object key, Map<?, Double> scoreMembers, String nxxx, String ch) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zadd(RedisUtils.toBytes(key), RedisUtils.toBytesZ(scoreMembers), RedisUtils.toZAddParams(nxxx, ch));
            return l;
        }
    }

    public static double zincrby(Object key, double score, Object member) {
        try (Jedis jedis = RedisUtils.getJedis();){
            double d = jedis.zincrby(RedisUtils.toBytes(key), score, RedisUtils.toBytes(member));
            return d;
        }
    }

    public static Double zincrby(Object key, double score, Object member, String nxxx) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Double d = jedis.zincrby(RedisUtils.toBytes(key), score, RedisUtils.toBytes(member), RedisUtils.toZIncrByParams(nxxx));
            return d;
        }
    }

    public static long zcard(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zcard(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static long zcount(Object key, double min, double max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zcount(RedisUtils.toBytes(key), min, max);
            return l;
        }
    }

    public static long zcount(Object key, String min, String max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zcount(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max));
            return l;
        }
    }

    public static long zlexcount(Object key, String min, String max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zlexcount(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max));
            return l;
        }
    }

    public static Double zscore(Object key, Object member) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Double d = jedis.zscore(RedisUtils.toBytes(key), RedisUtils.toBytes(member));
            return d;
        }
    }

    public static Long zrank(Object key, Object member) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Long l = jedis.zrank(RedisUtils.toBytes(key), RedisUtils.toBytes(member));
            return l;
        }
    }

    public static Long zrevrank(Object key, Object member) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Long l = jedis.zrevrank(RedisUtils.toBytes(key), RedisUtils.toBytes(member));
            return l;
        }
    }

    public static long zrem(Object key, Object ... members) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zrem(RedisUtils.toBytes(key), RedisUtils.toBytes(members));
            return l;
        }
    }

    public static long zremrangeByRank(Object key, long start, long end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zremrangeByRank(RedisUtils.toBytes(key), start, end);
            return l;
        }
    }

    public static long zremrangeByLex(Object key, String min, String max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zremrangeByLex(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max));
            return l;
        }
    }

    public static long zremrangeByScore(Object key, double min, double max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zremrangeByScore(RedisUtils.toBytes(key), min, max);
            return l;
        }
    }

    public static long zremrangeByScore(Object key, String min, String max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zremrangeByScore(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max));
            return l;
        }
    }

    public static Set<byte[]> zrangeBytes(Object key, long start, long end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrange(RedisUtils.toBytes(key), start, end);
            return set;
        }
    }

    public static Set<String> zrange(Object key, long start, long end) {
        return RedisUtils.toString(RedisUtils.zrangeBytes(key, start, end));
    }

    public static Set<byte[]> zrevrangeBytes(Object key, long start, long end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrange(RedisUtils.toBytes(key), start, end);
            return set;
        }
    }

    public static Set<String> zrevrange(Object key, long start, long end) {
        return RedisUtils.toString(RedisUtils.zrevrangeBytes(key, start, end));
    }

    public static Set<Tuple> zrangeWithScores(Object key, long start, long end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeWithScores(RedisUtils.toBytes(key), start, end);
            return set;
        }
    }

    public static Set<Tuple> zrevrangeWithScores(Object key, long start, long end) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeWithScores(RedisUtils.toBytes(key), start, end);
            return set;
        }
    }

    public static Set<byte[]> zrangeByLexBytes(Object key, String min, String max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByLex(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max));
            return set;
        }
    }

    public static Set<String> zrangeByLex(Object key, String min, String max) {
        return RedisUtils.toString(RedisUtils.zrangeByLexBytes(key, min, max));
    }

    public static Set<byte[]> zrangeByLexBytes(Object key, String min, String max, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByLex(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max), offset, count);
            return set;
        }
    }

    public static Set<String> zrangeByLex(Object key, String min, String max, int offset, int count) {
        return RedisUtils.toString(RedisUtils.zrangeByLexBytes(key, min, max, offset, count));
    }

    public static Set<byte[]> zrevrangeByLexBytes(Object key, String max, String min) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByLex(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)max), RedisUtils.toBytes((Object)min));
            return set;
        }
    }

    public static Set<String> zrevrangeByLex(Object key, String max, String min) {
        return RedisUtils.toString(RedisUtils.zrevrangeByLexBytes(key, max, min));
    }

    public static Set<byte[]> zrevrangeByLexBytes(Object key, String max, String min, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByLex(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)max), RedisUtils.toBytes((Object)min), offset, count);
            return set;
        }
    }

    public static Set<String> zrevrangeByLex(Object key, String max, String min, int offset, int count) {
        return RedisUtils.toString(RedisUtils.zrevrangeByLexBytes(key, max, min, offset, count));
    }

    public static Set<byte[]> zrangeByScoreBytes(Object key, double min, double max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByScore(RedisUtils.toBytes(key), min, max);
            return set;
        }
    }

    public static Set<String> zrangeByScore(Object key, double min, double max) {
        return RedisUtils.toString(RedisUtils.zrangeByScoreBytes(key, min, max));
    }

    public static Set<byte[]> zrangeByScoreBytes(Object key, double min, double max, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByScore(RedisUtils.toBytes(key), min, max, offset, count);
            return set;
        }
    }

    public static Set<String> zrangeByScore(Object key, double min, double max, int offset, int count) {
        return RedisUtils.toString(RedisUtils.zrangeByScoreBytes(key, min, max, offset, count));
    }

    public static Set<byte[]> zrangeByScoreBytes(Object key, String min, String max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByScore(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max));
            return set;
        }
    }

    public static Set<String> zrangeByScore(Object key, String min, String max) {
        return RedisUtils.toString(RedisUtils.zrangeByScoreBytes(key, min, max));
    }

    public static Set<byte[]> zrangeByScoreBytes(Object key, String min, String max, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByScore(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max), offset, count);
            return set;
        }
    }

    public static Set<String> zrangeByScore(Object key, String min, String max, int offset, int count) {
        return RedisUtils.toString(RedisUtils.zrangeByScoreBytes(key, min, max, offset, count));
    }

    public static Set<byte[]> zrevrangeByScoreBytes(Object key, double max, double min) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByScore(RedisUtils.toBytes(key), max, min);
            return set;
        }
    }

    public static Set<String> zrevrangeByScore(Object key, double max, double min) {
        return RedisUtils.toString(RedisUtils.zrevrangeByScoreBytes(key, max, min));
    }

    public static Set<byte[]> zrevrangeByScoreBytes(Object key, double max, double min, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByScore(RedisUtils.toBytes(key), max, min, offset, count);
            return set;
        }
    }

    public static Set<String> zrevrangeByScore(Object key, double max, double min, int offset, int count) {
        return RedisUtils.toString(RedisUtils.zrevrangeByScoreBytes(key, max, min, offset, count));
    }

    public static Set<byte[]> zrevrangeByScoreBytes(Object key, String max, String min) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByScore(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)max), RedisUtils.toBytes((Object)min));
            return set;
        }
    }

    public static Set<String> zrevrangeByScore(Object key, String max, String min) {
        return RedisUtils.toString(RedisUtils.zrevrangeByScoreBytes(key, max, min));
    }

    public static Set<byte[]> zrevrangeByScoreBytes(Object key, String max, String min, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByScore(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)max), RedisUtils.toBytes((Object)min), offset, count);
            return set;
        }
    }

    public static Set<String> zrevrangeByScore(Object key, String max, String min, int offset, int count) {
        return RedisUtils.toString(RedisUtils.zrevrangeByScoreBytes(key, max, min, offset, count));
    }

    public static Set<Tuple> zrangeByScoreWithScores(Object key, double min, double max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByScoreWithScores(RedisUtils.toBytes(key), min, max);
            return set;
        }
    }

    public static Set<Tuple> zrangeByScoreWithScores(Object key, double min, double max, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByScoreWithScores(RedisUtils.toBytes(key), min, max, offset, count);
            return set;
        }
    }

    public static Set<Tuple> zrangeByScoreWithScores(Object key, String min, String max) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByScoreWithScores(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max));
            return set;
        }
    }

    public static Set<Tuple> zrangeByScoreWithScores(Object key, String min, String max, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrangeByScoreWithScores(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)min), RedisUtils.toBytes((Object)max), offset, count);
            return set;
        }
    }

    public static Set<Tuple> zrevrangeByScoreWithScores(Object key, double max, double min) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByScoreWithScores(RedisUtils.toBytes(key), max, min);
            return set;
        }
    }

    public static Set<Tuple> zrevrangeByScoreWithScores(Object key, double max, double min, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByScoreWithScores(RedisUtils.toBytes(key), max, min, offset, count);
            return set;
        }
    }

    public static Set<Tuple> zrevrangeByScoreWithScores(Object key, String max, String min) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByScoreWithScores(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)max), RedisUtils.toBytes((Object)min));
            return set;
        }
    }

    public static Set<Tuple> zrevrangeByScoreWithScores(Object key, String max, String min, int offset, int count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            Set set = jedis.zrevrangeByScoreWithScores(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)max), RedisUtils.toBytes((Object)min), offset, count);
            return set;
        }
    }

    public static long zinterstore(Object dstkey, Object ... sets) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zinterstore(RedisUtils.toBytes(dstkey), RedisUtils.toBytes(sets));
            return l;
        }
    }

    public static long zinterstore(Object dstkey, double[] weights, String aggregate, Object ... sets) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zinterstore(RedisUtils.toBytes(dstkey), RedisUtils.toZParams(weights, aggregate), RedisUtils.toBytes(sets));
            return l;
        }
    }

    public static long zunionstore(Object dstkey, Object ... sets) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zunionstore(RedisUtils.toBytes(dstkey), RedisUtils.toBytes(sets));
            return l;
        }
    }

    public static long zunionstore(Object dstkey, double[] weights, String aggregate, Object ... sets) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.zunionstore(RedisUtils.toBytes(dstkey), RedisUtils.toZParams(weights, aggregate), RedisUtils.toBytes(sets));
            return l;
        }
    }

    public static ScanResult<Tuple> zscan(Object key, String cursor) {
        try (Jedis jedis = RedisUtils.getJedis();){
            ScanResult scanResult = jedis.zscan(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)cursor));
            return scanResult;
        }
    }

    public static ScanResult<Tuple> zscan(Object key, String cursor, String match, Integer count) {
        try (Jedis jedis = RedisUtils.getJedis();){
            ScanResult scanResult = jedis.zscan(RedisUtils.toBytes(key), RedisUtils.toBytes((Object)cursor), RedisUtils.toScanParams(match, count));
            return scanResult;
        }
    }

    public static boolean pfadd(Object key, Object ... elements) {
        try (Jedis jedis = RedisUtils.getJedis();){
            boolean bl = jedis.pfadd(RedisUtils.toBytes(key), RedisUtils.toBytes(elements)) == 1L;
            return bl;
        }
    }

    public static long pfcount(Object key) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.pfcount(RedisUtils.toBytes(key));
            return l;
        }
    }

    public static long pfcount(Object ... keys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            long l = jedis.pfcount(RedisUtils.toBytes(keys));
            return l;
        }
    }

    public static void pfmerge(Object destkey, Object ... sourcekeys) {
        try (Jedis jedis = RedisUtils.getJedis();){
            jedis.pfmerge(RedisUtils.toBytes(destkey), RedisUtils.toBytes(sourcekeys));
        }
    }

    static {
        Properties config = new Properties();
        try (InputStream in = RedisUtils.class.getResourceAsStream("/redis.properties");){
            config.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String enable = config.getProperty("enable");
        if ("true".equals(enable)) {
            int maxTotal = Integer.parseInt(config.getProperty("pool.maxTotal"));
            int maxIdle = Integer.parseInt(config.getProperty("pool.maxIdle"));
            int maxWaitMillis = Integer.parseInt(config.getProperty("pool.maxWaitMillis"));
            boolean testOnBorrow = Boolean.parseBoolean(config.getProperty("pool.testOnBorrow"));
            String cluster = config.getProperty("cluster");
            String maxRedirections = config.getProperty("maxRedirections");
            String sentinels = config.getProperty("sentinels");
            String masterName = config.getProperty("masterName");
            String host = config.getProperty("host");
            String port = config.getProperty("port");
            int timeout = Integer.parseInt(config.getProperty("timeout"));
            int database = Integer.parseInt(config.getProperty("database"));
            String password = config.getProperty("password");
            if ("".equals(password)) {
                password = null;
            }
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(maxTotal);
            poolConfig.setMaxIdle(maxIdle);
            poolConfig.setMaxWaitMillis((long)maxWaitMillis);
            poolConfig.setTestOnBorrow(testOnBorrow);
            if (cluster != null) {
                int intMaxRedirections = Integer.parseInt(maxRedirections);
                HashSet<HostAndPort> clusterNodes = new HashSet<HostAndPort>();
                for (String node : cluster.split(",")) {
                    String nodeHost = node.split(":")[0];
                    int nodePort = Integer.parseInt(node.split(":")[1]);
                    clusterNodes.add(new HostAndPort(nodeHost, nodePort));
                }
                jedisCluster = new JedisCluster(clusterNodes, timeout, intMaxRedirections, (GenericObjectPoolConfig)poolConfig);
            } else if (sentinels != null) {
                HashSet<String> sentinelSet = new HashSet<String>();
                for (String sentinel : sentinels.split(",")) {
                    sentinelSet.add(sentinel);
                }
                jedisSentinelPool = new JedisSentinelPool(masterName, sentinelSet, (GenericObjectPoolConfig)poolConfig, timeout, password, database);
            } else if (host != null) {
                int intPort = Integer.parseInt(port);
                jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, intPort, timeout, password, database);
            }
        }
    }
}

