/*
 * Decompiled with CFR 0.152.
 */
package com.github.wslf.github.fileapi;

import com.github.wslf.github.fileapi.requests.FileRequest;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import java.io.IOException;
import javax.annotation.Nullable;

public class RequestProcessor {
    private static final HttpTransport HTTP_TRANSPORT = new ApacheHttpTransport();
    private static final GsonFactory GSON_FACTORY = new GsonFactory();
    private static final HttpRequestFactory REQUEST_FACTORY = HTTP_TRANSPORT.createRequestFactory();

    public HttpResponse sendRequest(FileRequest fileRequest, String requestMethod) throws IOException {
        HttpRequest request = REQUEST_FACTORY.buildRequest(requestMethod, (GenericUrl)fileRequest, null);
        return this.sendRequest(request, fileRequest);
    }

    public HttpResponse sendPutRequest(FileRequest fileRequest) throws IOException {
        JsonHttpContent httpContent = new JsonHttpContent((JsonFactory)GSON_FACTORY, (Object)fileRequest);
        httpContent.setMediaType(new HttpMediaType("application/vnd.github.v3+json"));
        HttpRequest request = REQUEST_FACTORY.buildPutRequest((GenericUrl)fileRequest, (HttpContent)httpContent);
        return this.sendRequest(request, fileRequest);
    }

    private HttpResponse sendRequest(HttpRequest httpRequest, FileRequest fileRequest) throws IOException {
        this.addHeaders(httpRequest, fileRequest.getAuth());
        return httpRequest.execute();
    }

    private void addHeaders(HttpRequest request, @Nullable String auth) {
        if (auth != null) {
            request.getHeaders().setAuthorization(auth);
        }
        request.getHeaders().setContentType("application/vnd.github.v3+json");
    }
}

