/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.algorithm.jgit;

import com.github.difflib.algorithm.Change;
import com.github.difflib.algorithm.DiffAlgorithm;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.algorithm.jgit.DataList;
import com.github.difflib.algorithm.jgit.DataListComparator;
import com.github.difflib.patch.DeltaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;

public class HistogramDiff<T>
implements DiffAlgorithm<T> {
    @Override
    public List<Change> diff(List<T> original, List<T> revised) throws DiffException {
        Objects.requireNonNull(original, "original list must not be null");
        Objects.requireNonNull(revised, "revised list must not be null");
        EditList diffList = new EditList();
        diffList.addAll((Collection)new org.eclipse.jgit.diff.HistogramDiff().diff(new DataListComparator(), new DataList<T>(original), new DataList<T>(revised)));
        ArrayList<Change> patch = new ArrayList<Change>();
        for (Edit edit : diffList) {
            DeltaType type = DeltaType.EQUAL;
            switch (edit.getType()) {
                case DELETE: {
                    type = DeltaType.DELETE;
                    break;
                }
                case INSERT: {
                    type = DeltaType.INSERT;
                    break;
                }
                case REPLACE: {
                    type = DeltaType.CHANGE;
                }
            }
            patch.add(new Change(type, edit.getBeginA(), edit.getEndA(), edit.getBeginB(), edit.getEndB()));
        }
        return patch;
    }
}

